<%
Class ConfParse
	Private Data
	Public CharSet
	Public ErrorMsg
	
	Public Sub Load(strFile)
		Dim oStream, fso
		strFile = Server.MapPath(strFile)
		Set fso = Server.CreateObject("Scripting.FileSystemObject")
		If fso.FileExists(strFile) Then
			Set oStream = Server.CreateObject ("ADODB.Stream")
			oStream.Type = 2
			oStream.Mode = 3
			oStream.Open
			oStream.CharSet = CharSet
			oStream.LoadFromFile(strFile)
			ParseData(oStream.ReadText)
			oStream.Close
			Set oStream = Nothing
		Else
			ErrorMsg = "Template configure file dos not exists!"
		End If
		Set fso = Nothing
	End Sub
	
	Public Default Property Get Item(strItem, strName)
		Dim strKey
		strKey = LCase(Trim(strItem) &","& Trim(strName))
		If Data.Exists(strKey) Then
			Item = Data.Item(strKey)
		End If
	End Property
	
	Private Sub ParseData(strData)
		Dim RegEx, Match, Matchs, strKey, strVal
		
		strData = ReplaceData(strData)
		
		Set RegEx = New RegExp
		RegEx.IgnoreCase = True
		RegEx.Global = True
		RegEx.Pattern = "\n\[(.+?)\]([\s\S]+?)\n\["
		Set Matchs = RegEx.Execute(strData)
		For Each Match In Matchs
			strKey = Trim(RegEx.Replace(Match.Value,"$1"))
			strVal = Trim(RegEx.Replace(Match.Value,"$2"))
			ParseItem strKey, strVal
		Next
		Set Matchs = Nothing
		Set RegEx = Nothing
	End Sub
	
	Private Sub ParseItem(strItem, strData)
		Dim RegEx, Match, Matchs, strKey, strVal

		Set RegEx = New RegExp
		RegEx.IgnoreCase = True
		RegEx.Global = True
		RegEx.Pattern = "\n(.+?)=(.+?)\r"
		Set Matchs = RegEx.Execute(strData)
		For Each Match In Matchs
			strKey = Trim(RegEx.Replace(Match.Value,"$1"))
			strVal = Trim(RegEx.Replace(Match.Value,"$2"))
			strKey = LCase(strItem &","& strKey)
			If Data.Exists(strKey) Then
				Data.Item(strKey) = Trim(strVal)
			Else
				Data.Add strKey, strVal
			End If
		Next
		Set Matchs = Nothing
		Set RegEx = Nothing
	End Sub

	Private Function ReplaceData(strData)
		Dim strSymb
		strSymb = vbCrLf &"["
		strData = Replace(strData, strSymb, strSymb & strSymb)
		strData = vbCrLf & strData & strSymb
		ReplaceData = strData
	End Function
	
	Private Sub Class_Initialize()
		CharSet = "gb2312"
		ErrorMsg = ""
		Set Data = Server.CreateObject("Scripting.Dictionary")
	End Sub
	
	Private Sub Class_Terminate()
		If IsObject(Data) Then Set Data = Nothing
	End Sub
End Class
%>