<?php
include "../../corelib/Library.php";
header("Content-Type: text/html; charset=UTF-8");

doLoad();

function doLoad(){
	global $CoreDB, $CoreConfig;
	$tmpCMD = getQuery("cmd");
	$CoreDB->doConnect();
	$tmpUpdateServer = $CoreConfig->getConfig("updateserver");
	
	switch($tmpCMD){
	case "connect":
		$CoreConfig->setConfig("UpdateGradeNo",0);
		setSession("UpdatePause", "no");
		echo "yes";
		break;
	case "reconnect":
		echo "yes";
		break;
	case "communication":
		$tmpQueryString = getVariable("QUERY_STRING");
		$tmpQueryString = str_replace("=communication&command","",$tmpQueryString);
		echo getContent($tmpUpdateServer . "?". $tmpQueryString);
		break;
	case "initupgrade":
		$tmpCSerialNumber = getQuery("UpgradeContent");
		$tmpContent = getContent($tmpUpdateServer . "?cmd=compare&SerialNumber=" . $tmpCSerialNumber);
		
		$tmpAry = split("\\$", $tmpContent);
		$tmpAryNum = count($tmpAry)-1;
		for ($tmpI = 0; $tmpI <= $tmpAryNum ; $tmpI++){
			$tmpSubAry = split("\|",$tmpAry[$tmpI]);
			if (count($tmpSubAry) == 4){
				$tmpSerialID = $tmpSubAry[0];
				$tmpSerialNumber = $tmpSubAry[1];
				$tmpItemCount = $tmpSubAry[2];
				$tmpUpdateTime = $tmpSubAry[3];
				
				//echo $tmpSerialID . " - " . $tmpSerialNumber . " - " . $tmpItemCount . " - " . $tmpUpdateTime . "<br>";
				//exit();
				doInsertUpgradeQueue($tmpSerialID,$tmpSerialNumber,$tmpItemCount,$tmpUpdateTime);
			}
		}
		?>
		<script language="javascript">parent.doAPIInitUpgradeSucceed();</script>
		<?php
		break;
	case "next":
		if (getSession("UpdatePause") == "yes"){
			echo "Pause";
			return;
		}
		
		$tmpSQL = "select count(*) from WG_UpdateQueue";
		$tmpRSCount = $CoreDB->getQuery($tmpSQL);
		$tmpUpgradeCount = $tmpRSCount->Fields[0]->Value;
		
		$tmpSQL = "select count(*) from WG_UpdateQueue where [Upgraded]=1";
		$tmpRSCount = $CoreDB->getQuery($tmpSQL);
		$tmpUpgradedCount = $tmpRSCount[0];
		
		$tmpSQL = "select top 1 * from WG_UpdateQueue where [Upgraded]=0 order by UpdateTime asc";
		$tmpRS = $CoreDB->getQuery($tmpSQL);
		if ($tmpRS->eof){
			echo "over";
		}else{
			$tmpScale = intval((((($tmpRS->Fields["UpgradeCount"]->Value)+1)/$tmpRS->Fields["ItemCount"]->Value)*100)+0.5);
			echo $tmpRS->Fields["SerialID"]->Value . "|" . ($tmpRS->Fields["UpgradeCount"]->Value+1) . "|" . $tmpScale . "|" . ($tmpUpgradedCount+1) . "|" . $tmpUpgradeCount ;
		}
		break;
	case "parseupgrade":
		$tmpQueryString = getQuery("UpgradeContent");
		
		$tmpContent = getContent($tmpUpdateServer . "?cmd=upgrade&" . $tmpQueryString);
		
		$tmpAry = split("\\|\\$\\|", $tmpContent);
	
		$tmpSerialID = $tmpAry[0];
		$tmpCodeID = $tmpAry[1];
		$tmpCode = $tmpAry[2];
		$tmpRemark = $tmpAry[3];
		$tmpRank = $tmpAry[4];
		
		//echo $tmpSerialID . " - " . $tmpCodeID . " - " . $tmpCode . " - " . $tmpRemark . " - " . $tmpRank;
		//exit();
		
		doInsertCharacter($tmpSerialID,$tmpCodeID,$tmpCode,$tmpRemark,$tmpRank);
		doUpdateUpgradeQueue($tmpSerialID);
		?>
		<script language="javascript">parent.doAPIUpdateContinue();</script>
		<?php
		break;
	}
	
	$CoreDB->doDisConnect();

}

function doInsertCharacter($strSerialID, $strCodeID, $strCode, $strRemark, $strRank){
	global $CoreDB;
	$tmpSQL = "select top 1 * from WG_Character where CodeID=" . $strCodeID;
	$tmpRS = $CoreDB->getQuery($tmpSQL);
	if ($tmpRS->eof){
		$tmpSQL = "select * from WG_Character where 1=2";
		$tmpRS = $CoreDB->_RS;
		$tmpConn = $CoreDB->_Conn;
		$tmpRS->Open($tmpSQL,$tmpConn,2,3,1);
		$tmpRS->addnew();
		$tmpRS->Fields["CodeID"]->Value = $strCodeID;
		$tmpRS->Fields["Code"]->Value = $strCode;
		$tmpRS->Fields["Remark"]->Value = $strRemark;
		$tmpRS->Fields["Rank"]->Value = $strRank;
		$tmpRS->update();
		$tmpRS->close();
	}
}

function doUpdateUpgradeQueue($strSerialID){
	global $CoreDB, $CoreConfig;
	$tmpPutPatchInfo = false;
	$CoreDB->doExecute("update WG_UpdateQueue set UpgradeCount=UpgradeCount+1 where SerialID=" . $strSerialID);
	
	
	$tmpSQL = "select top 1 * from WG_UpdateQueue where SerialID=" . $strSerialID;
	$tmpRS = $CoreDB->getQuery($tmpSQL);
	if (!$tmpRS->eof){
		$tmpSerialNumber = $tmpRS->Fields["SerialNumber"]->Value;
		$tmpItemCount = toInt($tmpRS->Fields["ItemCount"]->Value);
		$tmpUpgradeCount = toInt($tmpRS->Fields["UpgradeCount"]->Value);
		$tmpUpdateTime = FormatDateTime($tmpRS->Fields["UpdateTime"]->Value,2);
		if ($tmpItemCount == $tmpUpgradeCount){
			$CoreDB->doExecute("update WG_UpdateQueue set Upgraded=1 where SerialID=" . $strSerialID);
			$CoreDB->doExecute("insert into WG_UpdateLog([SerialID],[SerialNumber],[ItemCount],[UpdateTime],[UpgradeTime]) values(" . $strSerialID . ",'" . $tmpSerialNumber . "'," . $tmpItemCount . ",#" . $tmpRS->Fields["UpdateTime"]->Value . "#,#" . now() . "#)");
			$CoreConfig->setConfig("CSerialNumber",$tmpSerialNumber);
			$CoreConfig->setConfig("UpdateGradeNo",(toInt($CoreConfig->getConfig("UpdateGradeNo"))+1));
			$CoreConfig->setConfig("lastupdatetime",now());
			$tmpPutPatchInfo = true;
		}
		
		$tmpSQL = "select count(*) from WG_UpdateQueue where [Upgraded]=0";
		$tmpRSCount = $CoreDB->getQuery($tmpSQL);
		$tmpUpgradedCount = $tmpRSCount[0];
		if (toInt($tmpUpgradedCount) == 0){
			$CoreDB->doExecute("delete from WG_UpdateQueue");
		}
		
		if ($tmpPutPatchInfo){
			$tmpDisplay = "";
			if (toInt($CoreConfig->getConfig("UpdateGradeNo")) > 10) { $tmpDisplay = "display:none;"; }
				
			?>
			<script language="javascript">
				var re
				re = "<div style=<?php echo $tmpDisplay?> class=Item onmouseout=Item_OnMouseOut(this) onmouseover=Item_OnMouseOver(this)>"
				re = re + "	<div class=No><?php echo $CoreConfig->getConfig("UpdateGradeNo")?></div>"
				re = re + "	<div class=PatchNumber>Patch-<?php echo $tmpSerialNumber?></div>"
				re = re + "	<div class=UpdateTime><?php echo $tmpUpdateTime?></div>"
				re = re + "	<div class=Size><?php echo $tmpItemCount?></div>"
				re = re + "</div>"
				parent.doAPIUpdateContinue(re);
			</script>
			<?php
			exit();
		}
	}
}

function doInsertUpgradeQueue($strSerialID, $strSerialNumber, $strItemCount, $strUpdateTime){
	global $CoreDB;
	$tmpSQL = "select top 1 * from WG_UpdateQueue where SerialNumber='" . $strSerialNumber . "'";
	$tmpRS = $CoreDB->getQuery($tmpSQL);
	if ($tmpRS->eof){
		$tmpSQL = "select * from WG_UpdateQueue where 1=2";
		$tmpRS = $CoreDB->_RS;
		$tmpConn = $CoreDB->_Conn;
		$tmpRS->Open($tmpSQL,$tmpConn,2,3,1);
		$tmpRS->addnew();
		$tmpRS->Fields["SerialID"]->Value = $strSerialID;
		$tmpRS->Fields["SerialNumber"]->Value = $strSerialNumber;
		$tmpRS->Fields["ItemCount"]->Value = $strItemCount;
		$tmpRS->Fields["UpdateTime"]->Value = $strUpdateTime;
		$tmpRS->update();
		$tmpRS->close();
	}
}

?>