<?php
include "../../corelib/Library.php";
include "../../corelib/Library.MD5.php";
header("Content-Type: text/html; charset=UTF-8");

doLoad();

function doLoad(){
	global $CoreDB, $CoreConfig;
	$tmpCMD = getQuery("cmd");
	$CoreDB->doConnect();
	$tmpupgradeserver = $CoreConfig->getConfig("upgradeserver");
	
	switch($tmpCMD){
	case "connect":
		$CoreConfig->setConfig("UpGradeNo",0);
		setSession("UpgradePause", "no");
		echo "yes";
		break;
	case "reconnect":
		echo "yes";
		break;
	case "communication":
		$tmpQueryString = getVariable("QUERY_STRING");
		$tmpQueryString = str_replace("=communication&command","",$tmpQueryString);
		echo getContent($tmpupgradeserver . "?". $tmpQueryString);
		break;
	case "initupgrade":
		$tmpCVersionNumber = getQuery("UpgradeContent");
		
		$tmpContent = getContent($tmpupgradeserver . "?cmd=compare&action=onlygetversion&VersionNumber=" . $tmpCVersionNumber);
		$CoreConfig->setConfig("temp_VersionNumber",$tmpContent);
		
		$tmpContent = getContent($tmpupgradeserver . "?cmd=compare&VersionNumber=" . $tmpCVersionNumber);
		
			
		$tmpAry = split("\\$", $tmpContent);
		$tmpAryNum = count($tmpAry)-2;
		
		
		for ($tmpI = 0; $tmpI <= $tmpAryNum ; $tmpI++){
			$tmpSubAry = split("\|",$tmpAry[$tmpI]);
			if (count($tmpSubAry) == 3){
				$tmpFileID = $tmpSubAry[0];
				$tmpFilepath = $tmpSubAry[1];
				$tmpFileMD5 = $tmpSubAry[2];
				
				//echo $tmpFileID . " - " . $tmpFilepath . " - " . $tmpFileMD5 . "<br>";
				//exit();
				doInsertUpgradeQueue($tmpFileID,$tmpFilepath,$tmpFileMD5);
			}
		}
		?>
		<script language="javascript">parent.doAPIInitUpgradeSucceed();</script>
		<?php
		break;
	case "next":
		if (getSession("UpgradePause") == "yes"){
			echo "Pause";
			return;
		}
		
		$tmpSQL = "select count(*) from WG_UpgradeQueue";
		$tmpRSCount = $CoreDB->getQuery($tmpSQL);
		$tmpUpgradeCount = $tmpRSCount->Fields[0]->Value;
		
		$tmpSQL = "select count(*) from WG_UpgradeQueue where [Upgraded]=1";
		$tmpRSCount = $CoreDB->getQuery($tmpSQL);
		$tmpUpgradedCount = $tmpRSCount[0];
		
		$tmpSQL = "select top 1 * from WG_UpgradeQueue where [Upgraded]=0 order by id asc";
		$tmpRS = $CoreDB->getQuery($tmpSQL);
		if ($tmpRS->eof){
			echo "over";
		}else{
			$tmpScale = intval(((($tmpUpgradedCount+1)/$tmpUpgradeCount)*100)+0.5);
			echo $tmpRS->Fields["FileID"]->Value . "|" . $tmpScale . "|" . ($tmpUpgradedCount+1) . "|" . $tmpUpgradeCount ;
		}
		break;
	case "parseupgrade":
		$tmpQueryString = getQuery("UpgradeContent");
		
		$tmpSubAry = split("\|", $tmpQueryString);
		$tmpFileID = $tmpSubAry[0];
		$tmpStat = $tmpSubAry[1];
		
		$tmpContent = getContent($tmpupgradeserver . "?cmd=upgrade&fileid=" . $tmpFileID);
		
		
		doUpdateUpgradeQueue($tmpFileID,$tmpContent,$tmpStat);
		
		?>
		<script language="javascript">parent.doAPIUpdateContinue();</script>
		<?php
		break;
	}
	
	$CoreDB->doDisConnect();

}

function doUpdateUpgradeQueue($strFileID, $strContent, $strStat){
	global $CoreDB, $CoreConfig;
	
	$tmpSQL = "select top 1 * from WG_UpgradeQueue where FileID=" . $strFileID;
	$tmpRS = $CoreDB->getQuery($tmpSQL);
	if (!$tmpRS->eof){
		$tmpFilepath = $tmpRS->Fields["Filepath"]->Value;
		$tmpMD5 = $tmpRS->Fields["md5"]->Value;
		
		setFileContent(toPath(getRootPath() . $tmpFilepath), $strContent);
		
		$CoreDB->doExecute("update WG_UpgradeQueue set Upgraded=1 where FileID=" . $strFileID);
		$CoreDB->doExecute("insert into WG_UpgradeLog([Filepath],[md5],[UpgradeTime]) values('" . $tmpFilepath . "','" . $tmpMD5 . "','" . now() . "')");
		
		if ($strStat == "over"){
			$CoreConfig->setConfig("VersionNumber",$CoreConfig->getConfig("temp_VersionNumber"));
			$CoreConfig->setConfig("UpGradeNo",(toInt($CoreConfig->getConfig("UpGradeNo"))+1));
			$CoreConfig->setConfig("lastupgradetime",now());
			
			$CoreDB->doExecute("delete from WG_UpgradeQueue");
		}
		
		$tmpDisplay = "";
		if (toInt($CoreConfig->getConfig("UpGradeNo")) > 10) { $tmpDisplay = "display:none;"; }
			
		?>
		<script language="javascript">
			var re
			re = "<div style=<?php echo $tmpDisplay?> class=Item onmouseout=Item_OnMouseOut(this) onmouseover=Item_OnMouseOver(this)>"
			re = re + "	<div class=No><?php echo $CoreConfig->getConfig("UpGradeNo")?></div>"
			re = re + "	<div class=UpgradeFilepath><?php echo $tmpFilepath?></div>"
			re = re + "	<div class=MD5><?php echo $tmpMD5;?></div>"
			re = re + "	<div class=Statu>Upgrade!</div>"
			re = re + "</div>"
			parent.doAPIUpdateContinue(re);
		</script>
		<?php
		exit();
	}
}

function doInsertUpgradeQueue($strFileID, $strFilepath, $strFileMD5){
	global $CoreDB;
	$tmpSQL = "select top 1 * from WG_UpgradeQueue where fileid=" . $strFileID;
	$tmpRS = $CoreDB->getQuery($tmpSQL);
	if ($tmpRS->eof){
		
		$strFilepath = str_replace("/Server.Upgrade/UpgradeFiles","",$strFilepath);
		
		// MD5 Check strFilepath strFileMD5
		$tmpMD5 = MD5File($strFilepath);
		
		if ($tmpMD5 == $strFileMD5){ return; }
		
		$tmpSQL = "select * from WG_UpgradeQueue where 1=2";
		$tmpRS = $CoreDB->_RS;
		$tmpConn = $CoreDB->_Conn;
		$tmpRS->Open($tmpSQL,$tmpConn,2,3,1);
		$tmpRS->addnew();
		$tmpRS->Fields["fileid"]->Value = $strFileID;
		$tmpRS->Fields["filepath"]->Value = $strFilepath;
		$tmpRS->Fields["md5"]->Value = $strFileMD5;
		$tmpRS->update();
		$tmpRS->close();
	}
}


function MD5File($strFilepath){
	$strFilepath = getRootPath() . $strFilepath;
	$tmpContent = getFileContent(toPath($strFilepath));
	if (!$tmpContent){
		return "File Not Exist!";
	}else{
		return to16MD5($tmpContent);
	}
}
?>