﻿<!-- #include file="AjaxPages.Inc.asp" -->
<%

Call doPageLoad()

if isPost() then
	dim tmpDataPath,tmpFileSize,ObjFSO
	tmpDataPath = getForm("datapath")
	if len(tmpDataPath)<1 then
		tmpDataPath = "\"
	end if
	
	if lcase(right(tmpDataPath,4))=".asp" then
		Set ObjFSO = CreateObject("Scripting.FileSystemObject")
		if Not ObjFSO.FileExists(Server.mappath(tmpDataPath)) then
			setPostError("您输入的文件地址不存在")
		else
			Call CoreConfig.setConfig("datapath","null")
			Call CoreDB.doExecute("delete from WG_FileInclude")
			Call doParseFile(Server.MapPath(tmpDataPath))
		end if
	else
		Call setPostMessage("您输入的文件类型非ASP，无法执行智能检索，但是仍然继续保存您的设置。")
	end if
	
	if not isPostError() then
		if CoreConfig.getConfig("datapath")="null" then Call CoreConfig.setConfig("datapath",tmpDataPath)
		Call CoreConfig.setConfig("lastupdatedate",now())
		Call CoreConfig.setConfig("lastupdateip",Request.ServerVariables("REMOTE_ADDR"))
		
		Call setPostMessage("成功更新数据库位置信息！")
	end if
	

end if

sub doParseFile(byval strFilePath)
	Call CoreDB.doConnect()
	if len(strFilePath)>0 then
		Dim ObjFSO,ObjFile
		Set ObjFSO = CreateObject("Scripting.FileSystemObject")
		if Not ObjFSO.FileExists(strFilePath) then Exit Sub
		Set ObjFile = ObjFSO.GetFile(strFilePath)
		if int(ObjFile.Size)<1 then exit sub
		
		Call CoreDB.doExecute("insert into WG_FileInclude([FilePath],[FileIsScan]) values('"&strFilePath&"',0)")
	end if
	dim tmpSQL : tmpSQL="select top 1 * from WG_FileInclude where [FileIsScan]=0 order by [id] desc"
	dim tmpRS : set tmpRS=CoreDB.getQuery(tmpSQL)
	if not tmpRS.eof then
		Call CoreDB.doExecute("update WG_FileInclude set [FileIsScan]=1 where [ID]="&tmpRS("id"))
		Call doScanFile(tmpRS("FilePath"))
	end if
end sub

sub doScanFile(byval strFilePath)
	Dim ObjFSO,ObjFile,tmpFileTextContent
	Set ObjFSO = CreateObject("Scripting.FileSystemObject")
	if Not ObjFSO.FileExists(strFilePath) then
		Call doParseFile("")
		exit sub
	end if
	Set ObjFile = ObjFSO.GetFile(strFilePath)
	if int(ObjFile.Size)<1 then
		Call doParseFile("")
		exit sub
	end if
	
	tmpFileTextContent = getFileContent(strFilePath)
	if len(tmpFileTextContent) < 1 then
		Call doParseFile("")
		exit sub
	end if
	
	if not doFindDataString(tmpFileTextContent,strFilePath) then
		Call doParseInclude(tmpFileTextContent,strFilePath)
		Call doParseFile("")
	end if
end sub

sub doParseInclude(byval strContent, byval strFilePath)
	'debug "<textarea>"&strContent&"</textarea>"
	Dim rRE,rMatch,rMatches,rFlags,rFlag,rFlagValue
	set rRE=new regExp
	rRE.IgnoreCase=True
	rRE.Global=True
	rRE.Pattern="<!--(.*?)#include(.*?)file(.*?)=(.*?)\""(.*?)([^{\#}\s]*)(.*?)\""(.*?)--(.*?)>"
	Set rMatches=rRE.Execute(strContent)
	For Each rMatch In rMatches
		rFlags=rMatch.value
		rFlag=mid(rFlags,instr(rFlags,"""")+1,instrrev(rFlags,"""")-instr(rFlags,"""")-1)
		'response.write "-"&rFlags&"-"&instr(rFlags,"""")&"-"&instrrev(rFlags,"""")&"-"&rFlag&"-<br>"
		Call doParseFilepath(rFlag,strFilePath)
	Next
	Set rMatch=Nothing:Set rMatches=Nothing:Set rRE=Nothing
end sub

sub doParseFilepath(byval strFileInclude, byval strPath)
	dim tmpAry,tmpAryNum,tmpI,tmpN,tmpPathString
	tmpAry = split(strPath,"\")
	tmpAryNum = ubound(tmpAry)
	tmpN = strCount(strFileInclude,"../")
	'debug strPath&" - "&tmpAryNum&" -"&tmpN&"<br>"
	
	if left(strFileInclude,1)="/" then
		tmpPathString = Server.MapPath("\") &"\"& replace(right(strFileInclude,len(strFileInclude)-1),"/","\")
	elseif instr(strFileInclude,"../")<1 then
		for tmpI = 0 to (tmpAryNum-1)
			tmpPathString = tmpPathString & tmpAry(tmpI) &"\"
		next
		tmpPathString = tmpPathString & replace(strFileInclude,"/","\")
	else
		for tmpI = 0 to (tmpAryNum-(tmpN+1))
			tmpPathString = tmpPathString & tmpAry(tmpI) &"\"
		next
		tmpPathString = tmpPathString & replace(mid(strFileInclude,instrrev(strFileInclude,"../")+3,len(strFileInclude)-instrrev(strFileInclude,"../")-2),"/","\")
	end if
	'debug " -- "&tmpPathString&"<br><br>"
	
	Call CoreDB.doExecute("insert into WG_FileInclude([FilePath],[FileIsScan]) values('"&tmpPathString&"',0)")
end sub

function doFindDataString(byval strContent, byval strFilePath)
	doFindDataString = false
	if instr(lcase(strContent),lcase("ADODB.Connection"))>0 then
		Call CoreDB.doExecute("update WG_FileInclude set [FileIsScan]=2 where [FileIsScan]=0")
		strFilePath = replace(lcase(strFilePath),lcase(server.MapPath("\")),"")
		strFilePath = replace(strFilePath,"\","/")
		Call CoreConfig.setConfig("datapath",strFilePath)
		Call setPostMessage("成功从您填写的文件中智能检索出数据库文件准确位置！")
		doFindDataString = true
	end if
end function

Function strCount(strA, strB)
	Dim lngA,lngB,lngC
	lngA = Len(strA)
	lngB = Len(strB)
	lngC = Len(Replace(strA, strB, ""))
	strCount = (lngA - lngC) / lngB
End Function

function getFileContent(byval strPath)
	if len(strCharset)<1 then strCharset=var_Charset
	dim re,tmpObject
  	On Error Resume Next
	set tmpObject=Server.CreateObject("ADODB.Stream")
	With tmpObject
		.Charset="utf-8"
		.Open
		.LoadFromFile strPath
		re=.ReadText
		.Close
	end With
	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
	getFileContent=re
end function

%>
<div class="BlockMain">
	<div class="Actions">
		<form action="" name="PostFrm" method="post">
			<li>
				<span class="ItemText">数据库连接文件位置:</span>
				<input name="datapath" type="text" size="50" value="<%=CoreConfig.getConfig("datapath")%>" />
				<div class="Remark">>>设置网站数据库连接文件所在位置，比如 /inc/conn.asp 这样的地址，
				如果确实不知道位置，那么请随意设置一个您网站下以 .asp 结尾的，会从数据库中读取数据的文件（比如 /news/view.asp），
				为了减少程序检索花费的时间，建议您填写后台登陆或者前台登陆的地址。（比如：/admin/login.asp ）</div>
			</li>
			<li class="Submit">
				<span class="IndexUpdateInfo">最后配置更新时间：<span class="mark"><%=CoreConfig.getConfig("lastupdatedate")%></span> 最后修改IP：<span class="mark"><%=CoreConfig.getConfig("lastupdateip")%></span></span>
				<input class="Btn" type="submit" value="更新配置(U)" />
			</li>
		</form>
	</div>
	<div class="clear"></div>
	<div class="Messages">
		
		安全贴士：<br />
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		“最后配置更新时间” 可以显示配置信息最后一次修改的时间，“最后修改IP”可以显示最后一次修改配置的登陆IP，
		如果配置最后一次修改时间您未登录过系统，并且该IP地址也不是您所在地区的IP地址，
		则可能是有其他未知非法使用者修改了配置信息，请您务必仔细检查！<br><br>
	</div>
</div>
<%Call doPageEnd()%>