﻿<!-- #include file="AjaxPages.Inc.asp" -->
<%

Call doPageLoad()

if isPost() then
	dim tmpAction, tmpDBPath
	tmpAction = getForm("action")
	if len(tmpAction)<1 then
		setPostError("请选择您要进行的操作。")
	end if
	
	if toInt(tmpAction)=1 then
			
		tmpDBPath = CoreConfig.getConfig("datapath")
		if right(tmpDBPath,3) <> "asp" then
			Call setPostError("数据库连接文件非ASP文件，无法进行挂载操作。")
		else
			Call doParse()
		end if
		
	else
		Call doUnParse()
	end if
	
	if not isPostError() then
		
		Call CoreConfig.setConfig("sqlsafe",tmpAction)
		
		Call CoreConfig.setConfig("lastupdatedate",now())
		Call CoreConfig.setConfig("lastupdateip",Request.ServerVariables("REMOTE_ADDR"))
		
		setPostMessage("成功更新主动防御设置")
	end if
	

end if


Sub doParse()
	Call doParseConnFile()
	Call doCopyDefenseFile()
	Call doCreateLogFile()
end sub

sub doUnParse()
	dim tmpContent,tmpDBPath,tmpPlace,tmpNContent
	tmpDBPath = CoreConfig.getConfig("datapath")
	tmpDBPath = server.mappath(tmpDBPath)
	tmpContent = getFileContent(tmpDBPath)
	
	if len(tmpContent) < 1 then
		setPostError("数据库连接文件不存在，请到“程序配置”->“库址设置”中设置数据库连接文件位置。")
		exit sub
	end if
	
	if instr(tmpContent,lcase("<!-- #include file=""Defense.Kernel.asp"" -->")) < 1 then
		setPostError("主动防御核心引擎没有挂载。")
		exit sub
	end if
	
	tmpPlace = instr(tmpContent,"<%")
	if toInt(tmpPlace) < 1 then
		setPostError("无法识别数据库连接文件，请联系守护精灵官方。")
		exit sub
	end if
	
	'tmpContent = replace(lcase(tmpContent),lcase("<!-- #include file=""Defense.Kernel.asp"" -->") & chr(10) ,"")
	'tmpContent = replace(lcase(tmpContent),lcase("'Option Explicit"),"Option Explicit")
	'response.write "<textarea rows=""35"" cols=""150"">"&tmpContent&"</textarea>"
	'response.end
	'Call setFileContent(tmpDBPath,tmpContent)
	Call doFileDelete(tmpDBPath)
	Call doFileMove(tmpDBPath &".Bak",tmpDBPath)
	
	tmpDBPath = CoreConfig.getConfig("datapath")
	tmpAry = split(tmpDBPath,"/")
	tmpDBPath = replace(tmpDBPath,tmpAry(ubound(tmpAry)),"Defense.Kernel.asp")
	tmpDBPath = server.mappath(tmpDBPath)
	
	doFileDelete(tmpDBPath)
end sub

sub doParseConnFile()
	dim tmpContent,tmpDBPath,tmpPlace,tmpNContent
	tmpDBPath = CoreConfig.getConfig("datapath")
	tmpDBPath = server.mappath(tmpDBPath)
	tmpContent = getFileContent(tmpDBPath)
	
	if len(tmpContent) < 1 then
		setPostError("数据库连接文件不存在，请到“程序配置”->“库址设置”中设置数据库连接文件位置。")
		exit sub
	end if
	
	if instr(tmpContent,lcase("<!-- #include file=""Defense.Kernel.asp"" -->")) > 0 then
		setPostError("主动防御核心引擎已经挂载过了。")
		exit sub
	end if
	
	tmpPlace = instr(instr(tmpContent,"<%@")+1,tmpContent,"<%")
	if toInt(tmpPlace) < 1 then
		setPostError("无法识别数据库连接文件，请联系守护精灵官方。")
		exit sub
	end if
	
	if toInt(tmpPlace)=1 then
		tmpNContent = "<!-- #include file=""Defense.Kernel.asp"" -->" & vbcrlf & tmpContent
	else
		tmpPlace = tmpPlace-1
		tmpNContent = mid(tmpContent,1,tmpPlace) & "<!-- #include file=""Defense.Kernel.asp"" -->" & chr(10) & mid(tmpContent,tmpPlace+1,len(tmpContent))
	end if
	
	tmpNContent = replace(lcase(tmpNContent),lcase("Option Explicit"),"'Option Explicit")
	'response.write "<textarea rows=""35"" cols=""150"">"&tmpNContent&"</textarea>"
	'response.end
	Call doFileCopy(tmpDBPath,tmpDBPath &".Bak")
	Call setFileContent(tmpDBPath,tmpNContent)
end sub

sub doCopyDefenseFile()
	dim tmpDefensePath,tmpDBPath,tmpAry
	
	tmpDefensePath = server.mappath(".")
	tmpDefensePath = replace(lcase(tmpDefensePath),lcase("\AjaxPages"),"\CoreFiles\Defense.Kernel.asp")
	
	tmpDBPath = CoreConfig.getConfig("datapath")
	tmpAry = split(tmpDBPath,"/")
	tmpDBPath = replace(tmpDBPath,tmpAry(ubound(tmpAry)),"Defense.Kernel.asp")
	tmpDBPath = server.mappath(tmpDBPath)
	
	'response.write tmpDefensePath &" - "&tmpDBPath
	Call doFileCopy(tmpDefensePath,tmpDBPath)
	
end sub

sub doCreateLogFile()
	dim tmpXMLStylePath
	
	Call doDirCreate(Server.mappath("/" & WEB_LOGPATH))
	
	tmpDefensePath = server.mappath(".")
	tmpDefensePath = replace(lcase(tmpDefensePath),lcase("\AjaxPages"),"\CoreFiles\XMLStyle.xsl")
	
	Call doFileCopy(tmpDefensePath,Server.mappath("/" & WEB_LOGPATH & "/XMLStyle.xsl"))
end sub




%>
<div class="BlockMain">
	<div class="Actions">
		<form action="" name="PostFrm" method="post">
			<li>
				<span class="ItemText">主动防御核心引擎：</span>
				<%if toInt(CoreConfig.getConfig("sqlsafe"))=0 then %>
					<input name="action" type="radio" class="RadioCheck" value="1" checked />挂载&nbsp;&nbsp;
					<input name="action" type="radio" class="RadioCheck" value="0" />卸载
				<%else%>
					<input name="action" type="radio" class="RadioCheck" value="1" />挂载&nbsp;&nbsp;
					<input name="action" type="radio" class="RadioCheck" value="0" checked />卸载
				<%end if%>
				
				<span style="padding-left:20px;">当前状态：</span>
				<%if toInt(CoreConfig.getConfig("sqlsafe"))=0 then %>
					未挂载
				<%else%>
					已挂载
				<%end if%>
				<div class="Remark">
					>>主动防御核心引擎有助于您的站点实时检测并且拦截入侵动作，该引擎不同于常规的SQL全局防注入，
					引擎采用复杂的拟人化正则匹配，判断更加精确，运算速度更快，通常执行时间小于0.1秒，
					对于修改后的特殊字符试图绕过检测也可以准确拦截，并且可以智能判断出是否为正常的数据提交以最大程度减少误拦截概率。
					<br><br>
					主动拦截日志默认在日志文件中以 yyyymmdd.xml 为文件名的方式进行记录。
				</div>
			</li>
			<li class="Submit">
				<span class="IndexUpdateInfo">最后配置更新时间：<span class="mark"><%=CoreConfig.getConfig("lastupdatedate")%></span> 最后修改IP：<span class="mark"><%=CoreConfig.getConfig("lastupdateip")%></span></span>
				<input class="Btn" type="submit" value="更新配置(U)" />
			</li>
		</form>
	</div>
	<div class="clear"></div>
	<div class="Messages">
		
		安全贴士：<br />
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		“最后配置更新时间” 可以显示配置信息最后一次修改的时间，“最后修改IP”可以显示最后一次修改配置的登陆IP，
		如果配置最后一次修改时间您未登录过系统，并且该IP地址也不是您所在地区的IP地址，
		则可能是有其他未知非法使用者修改了配置信息，请您务必仔细检查！<br><br>
	</div>
</div>
<%Call doPageEnd()%>