﻿<?php
include "AjaxPages.Inc.php";

doPageLoad();

if (isPost()){
	global $CoreConfig;
	$tmpAction = getForm("action");
	if (strlen($tmpAction) < 1){ setPostError("请选择您要进行的操作。"); }
	
	if (toInt($tmpAction) == 1){
			
		$tmpDBPath = $CoreConfig->getConfig("datapath");
		if (substr($tmpDBPath, toLength($tmpDBPath)-3, 3) != "php"){
			setPostError("数据库连接文件非PHP文件，无法进行挂载操作。");
		}else{
			doParse();
		}
	}else{
		doUnParse();
	}
	
	if (!isPostError()){
		$CoreConfig->setConfig("sqlsafe",$tmpAction);
		$CoreConfig->setConfig("lastupdatedate",date("Y-m-d H:i:s"));
		$CoreConfig->setConfig("lastupdateip",getVariable("REMOTE_ADDR"));
		
		setPostMessage("成功更新主动防御设置");
	}
}

function doParse(){
	doParseConnFile();
	doCopyDefenseFile();
	doCreateLogFile();
}

function doUnParse(){
	global $CoreConfig;
	$tmpDBPath = $CoreConfig->getConfig("datapath");
	$tmpDBPath = ServerMapPath($tmpDBPath);
	$tmpContent = getFileContent($tmpDBPath);
	
	if (!$tmpContent){
		setPostError("数据库连接文件不存在，请到“程序配置”->“库址设置”中设置数据库连接文件位置。");
		return;
	}
	
	if ((strpos($tmpContent,strtolower("<?php include 'Defense.Kernel.php'?>"))) < 0){
		setPostError("主动防御核心引擎没有挂载。");
		return;
	}
	
	$tmpPlace = strpos($tmpContent,"<?");
	if (toInt($tmpPlace) < 0){
		setPostError("无法识别数据库连接文件，请联系守护精灵官方。");
		return;
	}
	
	$tmpContent = str_replace("<?php include 'Defense.Kernel.php'?>" ,"",$tmpContent);
	setFileContent($tmpDBPath,$tmpContent);
	
	$tmpDBPath = $CoreConfig->getConfig("datapath");
	doFileDelete($tmpDBPath);
	doFileMove($tmpDBPath . ".Bak",$tmpDBPath);
	
	$tmpAry = split("/",$tmpDBPath);
	$tmpDBPath = str_replace($tmpAry[count($tmpAry)-1],"Defense.Kernel.php",$tmpDBPath);
	$tmpDBPath = ServerMapPath($tmpDBPath);
	
	doFileDelete($tmpDBPath);
}

function doParseConnFile(){
	global $CoreConfig;
	$tmpDBPath = $CoreConfig->getConfig("datapath");
	
	$tmpDBPath = ServerMapPath($tmpDBPath);
	$tmpContent = getFileContent($tmpDBPath);
	
	$isUTF8 = false;

	// For debug .
	//if (is_utf8($tmpContent)){ $isUTF8 = true; }
	if (!$tmpContent){
		setPostError("数据库连接文件不存在，请到“程序配置”->“库址设置”中设置数据库连接文件位置。");
		return;
	}
	
	if (strpos($tmpContent,strtolower("<?php include 'Defense.Kernel.php'?>")) > 0){
		setPostError("主动防御核心引擎已经挂载过了。");
		return;
	}
	
	
	if ((strpos($tmpContent,"<?")) >= 0){
		$tmpIncludeContent = "<?php include 'Defense.Kernel.php'?>";
		if ($isUTF8){ $tmpIncludeContent = iconv("GB2312","UTF-8",$tmpIncludeContent); }
		$tmpNContent = $tmpIncludeContent . $tmpContent;
	}else{
		
		setPostError("无法识别数据库连接文件，请联系守护精灵官方。");
		return;
	}
	
	doFileCopy($tmpDBPath,$tmpDBPath . ".Bak");
	setFileContent($tmpDBPath,$tmpNContent);
}

function doCopyDefenseFile(){
	global $CoreConfig;
	$tmpDefensePath = realpath($_SERVER['DOCUMENT_ROOT'] . getRootPath() . "\\Config\\CoreFiles\\Defense.Kernel.php");
	
	$tmpDBPath = $CoreConfig->getConfig("datapath");
	$tmpAry = split("/",$tmpDBPath);
	$tmpDBPath = str_replace($tmpAry[count($tmpAry)-1],"Defense.Kernel.php",$tmpDBPath);
	$tmpDBPath = ServerMapPath($tmpDBPath);
	
	doFileCopy($tmpDefensePath,$tmpDBPath);
}

function doCreateLogFile(){
	global $WEB_LOGPATH;
	doDirCreate(ServerMapPath("/" . $WEB_LOGPATH));
	$tmpDefensePath = $_SERVER['DOCUMENT_ROOT'] . getRootPath() . "\\Config\\CoreFiles\\XMLStyle.xsl";
	doFileCopy($tmpDefensePath, ServerMapPath("/" . $WEB_LOGPATH . "/XMLStyle.xsl"));
}

?>
<div class="BlockMain">
	<div class="Actions">
		<form action="" name="PostFrm" method="post">
			<li>
				<span class="ItemText">主动防御核心引擎：</span>
				<?php if (toInt($CoreConfig->getConfig("sqlsafe"))==0){?>
					<input name="action" type="radio" class="RadioCheck" value="1" checked />挂载&nbsp;&nbsp;
					<input name="action" type="radio" class="RadioCheck" value="0" />卸载
				<?php }else{?>
					<input name="action" type="radio" class="RadioCheck" value="1" />挂载&nbsp;&nbsp;
					<input name="action" type="radio" class="RadioCheck" value="0" checked />卸载
				<?php }?>
				
				<span style="padding-left:20px;">当前状态：</span>
				<?php if (toInt($CoreConfig->getConfig("sqlsafe"))==0){?>
					未挂载
				<?php }else{?>
					已挂载
				<?php }?>
				<div class="Remark">
					>>主动防御核心引擎有助于您的站点实时检测并且拦截入侵动作，该引擎不同于常规的SQL全局防注入，
					引擎采用复杂的拟人化正则匹配，判断更加精确，运算速度更快，通常执行时间小于0.1秒，
					对于修改后的特殊字符试图绕过检测也可以准确拦截，并且可以智能判断出是否为正常的数据提交以最大程度减少误拦截概率。
					<br><br>
					主动拦截日志默认在日志文件中以 yyyymmdd.xml 为文件名的方式进行记录。
				</div>
			</li>
			<li class="Submit">
				<span class="IndexUpdateInfo">最后配置更新时间：<span class="mark"><?php echo $CoreConfig->getConfig("lastupdatedate")?></span> 最后修改IP：<span class="mark"><?php echo $CoreConfig->getConfig("lastupdateip")?></span></span>
				<input class="Btn" type="submit" value="更新配置(U)" />
			</li>
		</form>
	</div>
	<div class="clear"></div>
	<div class="Messages">
		
		安全贴士：<br />
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		“最后配置更新时间” 可以显示配置信息最后一次修改的时间，“最后修改IP”可以显示最后一次修改配置的登陆IP，
		如果配置最后一次修改时间您未登录过系统，并且该IP地址也不是您所在地区的IP地址，
		则可能是有其他未知非法使用者修改了配置信息，请您务必仔细检查！<br><br>
	</div>
</div>
<?php doPageEnd()?>