﻿<%
Dim KOSDefense:Set KOSDefense = New KOSDefenseClass
Call KOSDefense.doParse()
Class KOSDefenseClass
	private Chr_Danger_Code,Chr_Timer_Begin
	
	public sub class_initialize()
		Chr_Timer_Begin = timer()
		Chr_Danger_Code = "'|;|and|or|exec|select|update|delete|declare"
	end sub
	
	public sub class_terminate()
		'response.write "<!-- GuardianGenius Runtime: " & FormatNumber((timer()-Chr_Timer_Begin)*1000,4) &"ms. -->"
	end sub

	'########################################
	'########################################
	public sub doParse()
		Call doSense("post")
		Call doSense("get")
		Call doSense("cookie")
		Call doSense("agent")
	end sub
	
	private sub debug(byval strer)
		response.write strer
	end sub
	
	private sub doSense(byval strType)
		dim ObjRequest,tmpArray,tmpI,tmpParameter,tmpSubParameter,tmpString
		
		if strType = "post" then
			if instr(Request.ServerVariables("CONTENT_TYPE"),"multipart/form-data")>0 then
				exit sub
			end if 
		end if
		
		select case strType
			case "post"	:	set ObjRequest = Request.Form
			case "get"	:	set ObjRequest = Request.QueryString
			case "cookie"	:	set ObjRequest = Request.cookies
		end select
		
		tmpArray = split(Chr_Danger_Code,"|")
		
		select case strType
		case "agent"
			dim tmpAgentString
			tmpAgentString = getUserAgent()
			'debug tmpAgentString&"<br />"
			For tmpI=0 To Ubound(tmpArray)
				If Instr(tmpAgentString,tmpArray(tmpI)) <> 0 Then
					if tmpString <> LCase(tmpAgentString) Then
						tmpString = LCase(tmpAgentString)
						Call doRegExpTest("Agent",tmpString,strType)
					end if
				End If
			Next
		case "cookie"
			For Each tmpParameter In ObjRequest
				if ObjRequest(tmpParameter).HasKeys then
					for each tmpSubParameter in ObjRequest(tmpParameter)
						'debug tmpParameter&" - "&tmpSubParameter&" - "&ObjRequest(tmpParameter)(tmpSubParameter)&"<br />"
						For tmpI=0 To Ubound(tmpArray)
							If Instr(LCase(ObjRequest(tmpParameter)(tmpSubParameter)),tmpArray(tmpI)) <> 0 Then
								if tmpString <> LCase(ObjRequest(tmpParameter)(tmpSubParameter)) Then
									tmpString = LCase(ObjRequest(tmpParameter)(tmpSubParameter))
									Call doRegExpTest(tmpParameter&" - "&tmpSubParameter,tmpString,strType)
								end if
							End If
						Next
					next
				else
					'debug tmpParameter&" - "&ObjRequest(tmpParameter)&"<br />"
					For tmpI=0 To Ubound(tmpArray)
						If Instr(LCase(ObjRequest(tmpParameter)),tmpArray(tmpI)) <> 0 Then
							if tmpString <> LCase(ObjRequest(tmpParameter)) Then
								tmpString = LCase(ObjRequest(tmpParameter))
								Call doRegExpTest(tmpParameter,tmpString,strType)
							end if
						End If
					Next	
				end if
				  
			
			
			Next
		case else
			if Len(ObjRequest)<1 then exit sub
			For Each tmpParameter In ObjRequest
				'debug tmpParameter&" - "&ObjRequest(tmpParameter)&"<br />"
				For tmpI=0 To Ubound(tmpArray)
					If Instr(LCase(ObjRequest(tmpParameter)),tmpArray(tmpI)) <> 0 Then
						if tmpString <> LCase(ObjRequest(tmpParameter)) Then
							tmpString = LCase(ObjRequest(tmpParameter))
							Call doRegExpTest(tmpParameter,tmpString,strType)
						end if
					End If
				Next
			Next
		end select
		
		
	end sub
	
	private sub doRegExpTest(byval strParameter, byval strString, byval strType)
		select case strType
		case "get"
			Call doRegExpRun(strParameter,strString,strType,"A","(((\/\*\*\/*|\s)+)(and|or|like)((\/\*\*\/*|\s)+)([A-Za-z0-9\(\)\[\]\s\*\+\_]+)(.*)(\=|\<|\>)((\/\*\*\/*|\s)?)([A-Za-z0-9\(\)\[\]\s\*\+\_]+))")
			Call doRegExpRun(strParameter,strString,strType,"B","(((\/\*\*\/*|\s)*)(\;)((\/\*\*\/*|\s)*)((.*)(select|delete|insert|update|exec|declare)((\/\*\*\/*|\s)+)(.*)(\--)))")
		case "post"
			Call doRegExpRun(strParameter,strString,strType,"A","(((\/\*\*\/*|\s)+)(and|or|like)((\/\*\*\/*|\s)+)([A-Za-z0-9\(\)\[\]\s\*\+\_]+)(.*)(\=|\<|\>)((\/\*\*\/*|\s)?)([A-Za-z0-9\(\)\[\]\s\*\+\_]+))")
			Call doRegExpRun(strParameter,strString,strType,"B","(((\/\*\*\/*|\s)*)(\;)((\/\*\*\/*|\s)*)((.*)(select|delete|insert|update|exec|declare)((\/\*\*\/*|\s)+)(.*)(\--)))")
		case "cookie"
			Call doRegExpRun(strParameter,strString,strType,"A","(((\/\*\*\/*|\s)+)(and|or|like)((\/\*\*\/*|\s)+)([A-Za-z0-9\(\)\[\]\s\*\+\_]+)(.*)(\=|\<|\>)((\/\*\*\/*|\s)?)([A-Za-z0-9\(\)\[\]\s\*\+\_]+))")
			Call doRegExpRun(strParameter,strString,strType,"B","(((\/\*\*\/*|\s)*)(\;)((\/\*\*\/*|\s)*)((.*)(select|delete|insert|update|exec|declare)((\/\*\*\/*|\s)+)(.*)(\--)))")
		case "agent"
			'Call doRegExpRun(strParameter,strString,strType,"(((\/\*\*\/*|\s)+)(and|or|like)((\/\*\*\/*|\s)+)([A-Za-z0-9\(\)\[\]\s\*\+\_]+)(.*)(\=|\<|\>)((\/\*\*\/*|\s)?)([A-Za-z0-9\(\)\[\]\s\*\+\_]+))")
			Call doRegExpRun(strParameter,strString,strType,"A","(((\/\*\*\/*|\s)*)(\;)((\/\*\*\/*|\s)*)((.*)(select|delete|insert|update|exec|declare)((\/\*\*\/*|\s)+)(.*)(\--)))")
		end select
	end sub
	
	private sub doRegExpRun(byval strParameter, byval strString, byval strType, byval strMode, byval strPattern)
		dim ObjRegExp:Set ObjRegExp = New RegExp
		ObjRegExp.IgnoreCase = True
		ObjRegExp.Global = True
		ObjRegExp.Pattern = strPattern
		If ObjRegExp.Test(strString) Then
			'debug strType &" - "& strString &" - "& strPattern &"<br>"
			Call doCreateLog(strParameter,strString,strType,"Action:Stop - Mode:" & strMode)
		else
			if strType<>"agent" then
				'Call doCreateLog(strParameter,strString,strType,"Action:Pass - Mode:" & strMode)
			end if
		end if
		
	end sub
	
	private sub doCreateLog(byval strParameter, byval strString, byval strType, byval strStatus)
		dim tmpFilepath,tmpPageURL,tmpPostData,tmpCreateDate,tmpIP
		dim tmpPath,tmpFilename
		
		tmpPath="/#LOGPATH#/"
		tmpFilename=replace(cstr(toConvertDate(date())),"-","") & ".xml" 
		tmpFilepath=server.mappath(tmpPath & tmpFilename)
		
		tmpPageURL = Request.ServerVariables("URL")&"?"&Request.ServerVariables("QUERY_STRING")
		
		tmpPostData = "["&strType&"] {"&strParameter&"} " & strString
		tmpCreateDate = now()
		tmpIP = getClientIP()
		
		Call doWriteLog(tmpFilepath,tmpPageURL,tmpPostData,tmpCreateDate,tmpIP,strStatus)
		if Instr(strStatus,"Stop")>0 then
			response.charset="utf-8"
			response.write("<div style=""font-family:'Verdana';color:#333333;font-size:14px;""><span style=""font-size:13px;""><a style=""color:#333333;text-decoration:none;"" target=""_blank"" href=""http://Www.GuardianGenius.Com/"">守护精灵</a> 拦截到攻击动作！</span> <span style=""font-size:12px;cursor:pointer;cursor:hand;"" onclick=""javascrip:history.go(-1);"">[点击返回]</span><br><a style=""color:#333333;"" target=""_blank"" href=""http://Www.GuardianGenius.Com/"">GuardianGenius</a> to intercept an attack! <span style=""font-size:12px;cursor:pointer;cursor:hand;"" onclick=""javascrip:history.go(-1);"">[Click Back]</span></div>")
			response.end
		end if
	end sub
	
	private sub doWriteLog(byval strFilepath,byval strPageURL,byval strPostData,byval strCreateDate,byval strIP, byval strStatus)
		dim ObjFSO:set ObjFSO=server.CreateObject("scripting.filesystemobject") 
		
		if not ObjFSO.FileExists(strFilepath) then
			ObjFSO.CreateTextFile strFilepath 
			dim ObjFile:set ObjFile=ObjFSO.GetFile(strFilepath) 
			dim ObjFileStream:set ObjFileStream=ObjFile.OpenAsTextStream(2) 
			Call ObjFileStream.write("<?xml version=""1.0"" encoding=""gb2312"" ?>" & vbcrlf & "<?xml-stylesheet type='text/xsl' href='XMLStyle.xsl'?>" & vbcrlf & "<guardiangeniuslog></guardiangeniuslog>")
			set ObjFileStream=nothing 
			set ObjFile=nothing 
		end if  
		set ObjFSO=nothing 
		
		dim ObjXML:Set ObjXML = Server.CreateObject("msxml2.domdocument")   
		ObjXML.async = false   
		ObjXML.load(strFilepath)  
		if ObjXML.parseError.errorcode<>0 then
			
			exit sub 
		end if  
		
		dim ObjXMLDoc:set ObjXMLDoc=ObjXML.documentElement   
		
		dim ObjXMLNode:set ObjXMLNode=ObjXML.createElement("LogItem") 
		ObjXMLDoc.appendchild(ObjXMLNode) 
		
		dim ObjXMLSubNode
		set ObjXMLSubNode=ObjXML.createElement("pageurl")
		ObjXMLSubNode.appendchild(ObjXML.createCDATASection(strPageURL))
		ObjXMLNode.appendchild(ObjXMLSubNode)
		
		set ObjXMLSubNode=ObjXML.createElement("postdata") 
		ObjXMLSubNode.appendchild(ObjXML.createCDATASection(strPostData))
		ObjXMLNode.appendchild(ObjXMLSubNode)
		
		set ObjXMLSubNode=ObjXML.createElement("ipaddress") 
		ObjXMLSubNode.appendchild(ObjXML.createCDATASection(strIP))
		ObjXMLNode.appendchild(ObjXMLSubNode)
		
		set ObjXMLSubNode=ObjXML.createElement("datetime") 
		ObjXMLSubNode.appendchild(ObjXML.createCDATASection(strCreateDate))
		ObjXMLNode.appendchild(ObjXMLSubNode)
		
		set ObjXMLSubNode=ObjXML.createElement("status") 
		ObjXMLSubNode.appendchild(ObjXML.createCDATASection(strStatus))
		ObjXMLNode.appendchild(ObjXMLSubNode)
		
		ObjXML.save strFilepath
		set ObjXMLNode=nothing 
		set ObjXMLSubNode=nothing 
		set ObjXML=nothing 
	end sub
	
	private function toConvertDate(byval strDate) 
		if isdate(strDate) then toConvertDate=year(strDate) & "-" & toFillZero(month(strDate)) & "-" & toFillZero(day(strDate)) 
	end function 
	
	private function toFillZero(byval strer)
		toFillZero = strer
		if len(strer)=1 then toFillZero="0" & strer 
	end function 

	private function getClientIP()
		dim tmpIP,tmpAry,aa
		tmpIP=request.servervariables("REMOTE_ADDR")
		If Len(tmpIP)<1 Then tmpIP=request.servervariables("HTTP_X_FORWARDED_FOR")
		If InStr(tmpIP, ",") > 0 Then tmpIP = Left(tmpIP, InStr(tmpIP, ",") - 1)
		tmpAry = Split(tmpIP, ".")
		If UBound(tmpAry) = 3 Then
			For aa = 0 To UBound(tmpAry)
				If Not IsNumeric(tmpAry(aa)) Then
					tmpIP = USER_IP
					Exit For
				Else
					If tmpAry(aa) > 255 Or tmpAry(aa) < 0 Then
						tmpIP = USER_IP
						Exit For
					End If
				End If
			Next
		Else
			tmpIP=USER_IP
		End If
		getClientIP=tmpIP
	end function

	private function getUserAgent()
		getUserAgent = request.servervariables("HTTP_USER_AGENT")
	end function

end Class




%>