﻿<%
Dim Var_Errors,Var_Messages
Set Var_Errors = server.CreateObject("Scripting.Dictionary")
Set Var_Messages = server.CreateObject("Scripting.Dictionary")


'########################################
'################ page ##################
'########################################


Sub doPageLoad()
	Call CoreDB.doConnect()
end sub


Sub doPageEnd()
	Call CoreDB.doDisConnect()
	echo getPostError()
	echo getPostMessage()
end sub


'########################################
'################ echo ##################
'########################################

Sub debug(ByVal strer)
	response.write strer
End Sub

Sub echo(ByVal strer)
	response.write strer
End Sub

Sub go(byval strURL)
	if len(strURL)<1 then strURL=DIR_ROOT
	if left(strURL,1)="/" then strURL=DIR_ROOT&right(strURL,len(strURL)-1)
	response.clear
	response.redirect strURL
	response.end
End Sub

function isPost()
	isPost=false
	if lcase(getVariable("REQUEST_METHOD"))="post" then isPost=true
end function

function getVariable(byval strer)
	getVariable=request.servervariables(strer)
end function

function getClientIP()
	dim tmpIP,tmpAry,aa
	tmpIP=request.servervariables("REMOTE_ADDR")
	If Len(tmpIP)<1 Then tmpIP=request.servervariables("HTTP_X_FORWARDED_FOR")
	If InStr(tmpIP, ",") > 0 Then tmpIP = Left(tmpIP, InStr(tmpIP, ",") - 1)
	tmpAry = Split(tmpIP, ".")
	If UBound(tmpAry) = 3 Then
		For aa = 0 To UBound(tmpAry)
			If Not IsNumeric(tmpAry(aa)) Then
				tmpIP = USER_IP
				Exit For
			Else
				If tmpAry(aa) > 255 Or tmpAry(aa) < 0 Then
					tmpIP = USER_IP
					Exit For
				End If
			End If
		Next
	Else
		tmpIP=USER_IP
	End If
	getClientIP=tmpIP
end function


'########################################
'################ string ################
'########################################

function toInt(byval strer)
	if not isNumeric(strer) then strer = 0
	toInt = clng(strer)
end function

Function getFileSize(byval theSize)
	If theSize >= (1024 * 1024 * 1024) Then getFileSize = Fix((theSize / (1024 * 1024 * 1024)) * 100) / 100 & "G"
	If theSize >= (1024 * 1024) And theSize < (1024 * 1024 * 1024) Then getFileSize = Fix((theSize / (1024 * 1024)) * 100) / 100 & "M"
	If theSize >= 1024 And theSize < (1024 * 1024) Then getFileSize = Fix((theSize / 1024) * 100) / 100 & "K"
	If theSize >= 0 And theSize <1024 Then getFileSize = theSize & "B"
End Function

Function getRank(byval strRank)
	select case toInt(strRank)
	case 1
		getRank = "可疑代码"
	case 2
		getRank = "漏洞代码"
	case 3
		getRank = "后门代码"
	case 4
		getRank = "木马程序"
	case 5
		getRank = "极度危险"
	end select
end function

function getCutFilePath(byval strFilePath,byval strCut)
	if toLength(strFilePath) > toInt(strCut) then
		dim tmpAry,tmpAryNum,tmpAryItem,tmpI
		Dim tmpFilePathA,tmpFilePathB,tmpFilePathC
		tmpAry = split(strFilePath,"\")
		tmpAryNum = ubound(tmpAry)
		tmpAryItem = tmpAry(0) & "\"
		tmpFilePathA = tmpAryItem
		for tmpI = 1 to tmpAryNum
			tmpAryItem = tmpAryItem & tmpAry(tmpI) & "\"
			if toLength(tmpAryItem) <= (toInt(strCut)/2) then
				tmpFilePathA = tmpAryItem
			else
				exit for
			end if
		next
		
		
		if toLength(tmpAry(tmpAryNum)) >= (toInt(strCut)/2) then
			tmpFilePathB = right(tmpAry(tmpAryNum),(toInt(strCut)/2))
		else
			tmpAryItem = tmpAry(tmpAryNum)&"\"
			tmpFilePathB = tmpAryItem
		
			for tmpI = (tmpAryNum-1) to 0 step -1
				tmpAryItem =  tmpAry(tmpI) & "\" & tmpAryItem
				
				if toLength(tmpAryItem) <= (toInt(strCut)/2) then
					tmpFilePathB = tmpAryItem
				else
					exit for
				end if
			next
			
			
			tmpFilePathB = left(tmpFilePathB,toLength(tmpFilePathB)-1)
		end if
			
		tmpFilePathC = tmpFilePathA & "......" & tmpFilePathB
		getCutFilePath = tmpFilePathC
	else
		getCutFilePath = strFilePath
	end if
end function

function toLength(ByVal strer)
	Dim reLen,ll,tmpAsc
	reLen=Len(strer)
	For ll=1 To Len(strer)
		tmpAsc=Ascw(Mid(strer, ll, 1))
		If tmpAsc < 0 Then tmpAsc=tmpAsc + 65536
		If tmpAsc > 255 Then reLen=reLen + 1
	Next
	toLength=reLen
End Function

'########################################
'################ error #################
'########################################

Sub setPostError(ByVal strer)
	Var_Errors("Errors_"&(Var_Errors.Count+1)) = strer
End Sub

Function getPostError()
	dim tmpI,tmpMessages
	getPostError = ""
	If Not IsObject(Var_Errors) Then Exit Function
	If Var_Errors.Count < 1 Then Exit Function
	For Each tmpI In Var_Errors
		If Len(tmpMessages)<0 Then
			tmpMessages=Var_Errors(tmpI)
		Else
			tmpMessages=tmpMessages&"<br>"&Var_Errors(tmpI)
		End If
	Next
	if len(tmpMessages)>0 then
		getPostError = "<script>doMessageBox('"&tmpMessages&"','click')</script>"
	end if
End Function

Function isPostError()
	isPostError = false
	If Not IsObject(Var_Errors) Then Exit Function
	If Var_Errors.Count < 1 Then Exit Function
	isPostError = true
End Function


'########################################
'############### message ################
'########################################

Sub setPostMessage(ByVal strer)
	Var_Messages("Messages") = strer
End Sub

Function getPostMessage()
	dim tmpI,tmpMessages
	getPostMessage = ""
	If Not IsObject(Var_Messages) Then Exit Function
	If Var_Messages.Count < 1 Then Exit Function
	For Each tmpI In Var_Messages
		If Len(tmpMessages)<0 Then
			tmpMessages=Var_Messages(tmpI)
		Else
			tmpMessages=tmpMessages&"<br>"&Var_Messages(tmpI)
		End If
	Next
	if len(tmpMessages)>0 then
		getPostMessage = "<script>doMessageBox('"&tmpMessages&"','click')</script>"
	end if
End Function



'########################################
'################ request ###############
'########################################

function getQuery(byval strer)
	getQuery=trim(request.querystring(strer))
end function

function getForm(byval strer)
	getForm=trim(request.form(strer))
end Function

'########################################
'################ cache #################
'########################################
function getCache(byval strname)
	getCache=application("GuardianGenius_"&strname)
end function

sub setCache(byval strname,byval strvalue)
	application.lock
	application("GuardianGenius_"&strname)=strvalue
	application.unlock
end sub

sub delCache(byval strname)
	application.lock
	application.Contents.Remove "GuardianGenius_"&strname
	application.unlock
end sub

sub doNoCache()
	Application.Lock
	application.contents.Removeall
	Application.unLock
end sub


'########################################
'############### session ################
'########################################
function getSessionID()
	getSessionID=session.SessionID
end function

function getSession(byval strkey)
	getSession=session("GuardianGenius_"&strkey)
end function

sub setSession(byval strkey,byval strvalue)
	session("GuardianGenius_"&strkey)=strvalue
end sub

sub delSession(byval strkey)
	session.Contents.Remove "GuardianGenius_"&strkey
end Sub

sub doNoSession()
	session.Contents.Removeall
end sub


'########################################
'############### Cookies ################
'########################################

function getCookies(byval strkey)
	getCookies=trim(request.cookies("GuardianGenius")(strkey))
end function

sub setCookies(byval strkey,byval strvalue)
	response.cookies("GuardianGenius")(strkey)=strvalue
	response.Cookies("GuardianGenius").Expires=Date+300
end sub

sub delCookies(byval strkey)
	response.cookies("GuardianGenius")(strkey)=empty
end Sub

sub doNoCookies()
	response.cookies("GuardianGenius")=empty
end sub

'########################################
'############### Files ################
'########################################
function toPath(byval strer)
	toPath=server.mappath(strer)
end function

sub doFileCopy(byval strPathFrom,byval strPathTo)
	dim tmpObject
	On Error Resume Next
	set tmpObject=Server.CreateObject("Scripting.FileSystemObject")
	tmpObject.CopyFile strPathFrom,strPathTo
	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
end sub

sub doFileMove(byval strPathFrom,byval strPathTo)
	dim tmpObject
	On Error Resume Next
	set tmpObject=Server.CreateObject("Scripting.FileSystemObject")
	tmpObject.MoveFile strPathFrom,strPathTo
	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
end sub

sub doFileDelete(byval strPath)
	dim tmpObject
	On Error Resume Next
	set tmpObject=Server.CreateObject("Scripting.FileSystemObject")
	tmpObject.DeleteFile strPath
	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
end sub
	
sub doDirCreate(byval strPath)
	dim tmpObject
	On Error Resume Next
	set tmpObject=Server.CreateObject("Scripting.FileSystemObject")
	if not tmpObject.FolderExists(strPath) then tmpObject.CreateFolder(strPath)
  	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
end sub

sub doDirMove(byval strPathFrom,byval strPathTo)
	dim tmpObject
	On Error Resume Next
	set tmpObject=Server.CreateObject("Scripting.FileSystemObject")
	tmpObject.MoveFolder strPathFrom,strPathTo
  	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
end sub

function getFileContent(byval strPath)
	dim re,tmpObject
  	On Error Resume Next
	set tmpObject=Server.CreateObject("ADODB.Stream")
	With tmpObject
		.Charset=getFileCharset(strPath)
		.Open
		.LoadFromFile strPath
		re=.ReadText
		.Close
	end With
	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
	getFileContent=re
end function

function setFileContent(byval strPath, byval strContent)
	dim tmpObject
  	On Error Resume Next
	set tmpObject=Server.CreateObject("ADODB.Stream")
	With tmpObject
		.Type = 2
		.Open
		.Charset = getFileCharset(strPath)
		.Position = tmpObject.Size
		.WriteText = strContent
		.SaveToFile strPath,2
		.Close
	End With
	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
End function

function getFileCharset(byval strPath)
	dim tmpObject,tmpHeader,re
  	On Error Resume Next
	set tmpObject=Server.CreateObject("ADODB.Stream")
	With tmpObject
		.Type=1
		.mode=3
		.open
		.Position=0
		.LoadFromFile strPath
		tmpHeader=.read(2)
		.Close
	end With
	If AscB(MidB(tmpHeader,1,1))=&HEF And AscB(MidB(tmpHeader,2,1))=&HBB Then
		re="utf-8"
	ElseIf AscB(MidB(tmpHeader,1,1))=&HFF And AscB(MidB(tmpHeader,2,1))=&HFE Then
		re="unicode"
	Else
		re="gb2312"
	End If
	set tmpObject=nothing
	if err then err.clear
	On Error Goto 0
	getFileCharset = re
end function


'########################################
'############### XMLHTTP ################
'########################################

function getContent(byval strURL)
	getContent=getContentCharset(strURL,"")
end function

function getContentCharset(byval strURL,strCharset)
	dim re,tmpObject
	on error resume next
	Set tmpObject=Server.CreateObject("Msxml2.XMLHTTP")
	if err then Set tmpObject=Server.CreateObject("Microsoft.XMLHTTP")
	With tmpObject
		.Open "Get",strURL,False,"",""
		.Send
		re=.ResponseBody
	End With
	Set tmpObject=Nothing
	if not isNull(strCharset) then
		if len(strCharset)<1 then strCharset="utf-8"
		getContentCharset=toByte2StringCharset(re,strCharset)
	end if
end function

function getContentPost(byval strURL,byval strData)
	dim re,tmpObject
	on error resume next
	Set tmpObject=Server.CreateObject("Msxml2.XMLHTTP")
	if err then Set tmpObject=Server.CreateObject("Microsoft.XMLHTTP")
	With tmpObject
		.Open "Post",strURL,False,"",""
		.setRequestHeader "Content-Type","application/x-www-form-urlencoded"
		.Send strData
		re=.ResponseBody
	End With
	Set tmpObject=Nothing
	getContentPost=toByte2StringCharset(re,"utf-8")
end function

Function toByte2StringCharset(byval strer,byval strCharset)
	Dim tmpObject
	Set tmpObject=Server.CreateObject("ADODB.Stream")
	tmpObject.Type=1
	tmpObject.Mode =3
	tmpObject.Open
	tmpObject.Write strer
	tmpObject.Position=0
	tmpObject.Type=2
	tmpObject.Charset=strCharset
	toByte2StringCharset=tmpObject.ReadText 
	tmpObject.Close
	set tmpObject=nothing
End Function
	
%>