<%
'**************************************************
'函数名：ReplaceBadChar
'作  用：过滤非法的SQL字符
'参  数：strChar-----要过滤的字符
'返回值：过滤后的字符
'**************************************************
Function ReplaceBadChar(strChar)
    If strChar = "" Or IsNull(strChar) Then
        ReplaceBadChar = ""
        Exit Function
    End If
    Dim strBadChar, arrBadChar, tempChar, i
    strBadChar = "',%,^,&,?,(,),<,>,[,],/,\,;," & Chr(34) & "," & Chr(0) & ""
    arrBadChar = Split(strBadChar, ",")
    tempChar = strChar
    For i = 0 To UBound(arrBadChar)
        tempChar = Replace(tempChar, arrBadChar(i), "")
    Next
    ReplaceBadChar = tempChar
End Function
'**************************************************
'函数名：GetUrl
'作  用：得到当前页面的URL
'参  数：无
'返回值：Url
'**************************************************
Function GetUrl()
        On Error Resume Next
        Dim sTmp
        If LCase(request.ServerVariables("HTTPS")) = "off" Then
        sTmp = "http://"
        Else
        sTmp = "https://"
        End If
        sTmp = sTmp & request.ServerVariables("SERVER_NAME")
        If request.ServerVariables("SERVER_PORT") <> 80 Then sTmp = sTmp & ":" & request.ServerVariables("SERVER_PORT")
        sTmp = sTmp & request.ServerVariables("URL")
        If Trim(request.QueryString) <> "" Then sTmp = sTmp & "?" & Trim(request.QueryString)
        GetUrl = sTmp
End Function
'**************************************************
'函数名：strLength
'作  用：求字符串长度。汉字算两个字符，英文算一个字符。
'参  数：str  ----要求长度的字符串
'返回值：字符串长度
'**************************************************
function strLength(str)
	ON ERROR RESUME NEXT
	dim WINNT_CHINESE
	WINNT_CHINESE    = (len("中国")=2)
	if WINNT_CHINESE then
        dim l,t,c
        dim i
        l=len(str)
        t=l
        for i=1 to l
        	c=asc(mid(str,i,1))
            if c<0 then c=c+65536
            if c>255 then
                t=t+1
            end if
        next
        strLength=t
    else 
        strLength=len(str)
    end if
    if err.number<>0 then err.clear
end Function
'**************************************************
'函数名：HTMLEncode(reString)
'作  用：将HTML代码转化为文本
'参  数：reString--传入代码
'返回值：转化后的文本
'**************************************************
Function HTMLEncode(reString) 
	Dim Str:Str=reString
	If Not IsNull(Str) Then
		Str = Replace(Str, "&", "&amp;")
		Str = Replace(Str, ">", "&gt;")
		Str = Replace(Str, "<", "&lt;")
		Str = Replace(Str, CHR(32), "&nbsp;")
		Str = Replace(Str, CHR(9), "&nbsp;&nbsp;&nbsp;&nbsp;")
		Str = Replace(Str, CHR(9), "&#160;&#160;&#160;&#160;")
		Str = Replace(Str, CHR(34),"&quot;")
		Str = Replace(Str, CHR(39),"&#39;")
		Str = Replace(Str, CHR(13), "")
		Str = Replace(Str, CHR(10), "<br>")
		HTMLEncode = Str
	End If
End Function
'**************************************************
'函数名：ReHTMLEncode
'作  用：将文本转化为有格式的HTML代码
'参  数：reString--传入文本
'返回值：转化后的代码
'**************************************************
Function ReHTMLEncode(reString)
	Dim Str:Str=reString
	If Not IsNull(Str) Then
		Str = Replace(Str, "&amp;" ,"&")
		Str = Replace(Str, "&gt;", ">")
		Str = Replace(Str, "&lt;", "<")
		Str = Replace(Str, "&nbsp;", CHR(32))
		Str = Replace(Str, "&nbsp;&nbsp;&nbsp;&nbsp;", CHR(9))
		Str = Replace(Str, "&#160;&#160;&#160;&#160;", CHR(9))
		Str = Replace(Str, "&quot;", CHR(34))
		Str = Replace(Str, "&#39;", CHR(39))
		Str = Replace(Str, "", CHR(13))
		Str = Replace(Str, "<br>", CHR(10))
		Str = Replace(Str, "<br/>", CHR(10))
		ReHTMLEncode = Str
	End If
End Function
'**************************************************
'函数名：getDate
'作  用：格式化时间
'参  数：
'返回值：时间字串
'**************************************************
Function getDate(atime,mode)
	Dim sReturn
	if mode=0 then sReturn=year(atime)&"-"&month(atime)&"-"&day(atime)
	if mode=1 then sReturn=Right("0"&month(atime),2)&"-"&Right("0"&day(atime),2)
	getDate=sReturn
End Function
'**************************************************
'函数名：AlertInfo
'作  用：警告信息
'参  数：Alert_Info--警告信息，aNextPage--下一页面地址，aType--警告类型
'返回值：无
'**************************************************
Function AlertInfo(Alert_Info,aNextPage,aType)
  aType=cint(aType)
  Select Case aType
    Case 0:
	Response.Write"<script language='javascript'>alert('"& Alert_Info &"');history.back(-1);</script>"
  	Response.End
    Case 1:
	Response.Write"<script language='javascript'>alert('"& Alert_Info &"');location.href='"& aNextPage &"';</script>"
  	Response.End
    Case else:
	Response.Write"<script language='javascript'>alert('"& Alert_Info &"');</script>"
  	Response.End
  End Select
End Function
'**************************************************
'函数名：CheckNull
'作  用：检查是否为空
'参  数：para--传入的参数 info--中文描述
'返回值：不为空时传回para
'**************************************************
Function CheckNull(para,info)
	if IsNull(para) or IsEmpty(para) or para="" then
		AlertInfo info&"不能为空",,0
		response.end
	else
		CheckNull=para
	end if
end Function
'**************************************************
'函数名：CInt2
'作  用：检查整数值
'参  数：sInt--传入的数字
'返回值：取整后的数字
'**************************************************
Function CInt2(sInt)
	If IsNull(sInt) Or IsEmpty(sInt) Or Len(sInt)=0 Or Not IsNumeric(sInt) Then 
		AlertInfo "请填写整数",,0
		Exit Function 
	End If
	If InStr(sInt,".")>0 Then 
		AlertInfo "请填写整数",,0
		Exit Function
	End If
	CInt2=Int(sInt)
End Function
'**************************************************
'函数名：showPage(url,page,pagesize,RsCount,pageCount)
'作  用：分页显示条
'参  数：page----当前页数
'        url-----文件名
'        pagesize-----每页记录数
'        pageCount----页数
'        RsCount------总记录数
'返回值：
'**************************************************
function showPage(url,page,pagesize,RsCount,pageCount)
	response.write "<div class='page'>每页 "&pagesize&" 记录，"
	response.write "共 "&RsCount&" 记录，"
	response.write "第 "&page&" 页，"
	response.write "共 "&pagecount&" 页 "
	if instr(url,"?")=0 then

	response.write " <a href='"&url&"'>第一页</a> "
	if page-1>0 then
		response.write " <a href='"&url&"?page="&page-1&"'>上一页</a> "
	else
		response.write " 上一页 "
	end if
	if page+1<=pagecount then
		response.write " <a href='"&url&"?page="&page+1&"'>下一页</a> "
	else
		response.write " 下一页 "
	end if
	response.write " <a href='"&url&"?page="&pagecount&"'>最后一页</a></div>"

	else

	response.write " <a href='"&url&"'>第一页</a> "
	if page-1>0 then
		response.write " <a href='"&url&"&page="&page-1&"'>上一页</a> "
	else
		response.write " 上一页 "
	end if
	if page+1<=pagecount then
		response.write " <a href='"&url&"&page="&page+1&"'>下一页</a> "
	else
		response.write " 下一页 "
	end if
	response.write " <a href='"&url&"&page="&pagecount&"'>最后一页</a></div>"

	end if
end function
'**************************************************
'函数名：showPage2(url,page,pagesize,RsCount,pageCount)
'作  用：分页显示条
'参  数：page----当前页数
'        url-----文件名
'        pagesize-----每页记录数
'        pageCount----页数
'        RsCount------总记录数
'返回值：
'**************************************************
function showPage2(url,page,pagesize,RsCount,pageCount)
		showPage2="<div id='page'>"
		If page>1 then
			showPage2=showPage2&"<span><a href='"&url&"'>首页</a></span> "
		Else
			showPage2=showPage2&"<span>首页</span> "
		End if

		if page-1>0 then
			showPage2=showPage2&"<span><a href='"&url&"?page="&page-1&"'>上一页</a></span> "
		else
			showPage2=showPage2&"<span>上一页</span> "
		end If
		
		If pagecount<9 then
			For p=1 To pagecount
				If p<>page then
					showPage2=showPage2&"<span><a href='"&url&"?page="&p&"'>"&p&"</a></span> "
				Else
					showPage2=showPage2&"<span>"&p&"</span> "
				End if
			next
		Else
			If page<=5 Then
				For p=1 To 9
					If p<>page then
						showPage2=showPage2&"<span><a href='"&url&"?page="&p&"'>"&p&"</a></span> "
					Else
						showPage2=showPage2&"<span>"&p&"</span> "
					End if
				next
			ElseIf pagecount-page<=5 Then
				For p=pagecount+1-9 To pagecount
					If p<>page then
						showPage2=showPage2&"<span><a href='"&url&"?page="&p&"'>"&p&"</a></span> "
					Else
						showPage2=showPage2&"<span>"&p&"</span> "
					End if
				next
			Else
				For p=page-4 To page+4
					If p<>page then
						showPage2=showPage2&"<span><a href='"&url&"?page="&p&"'>"&p&"</a></span> "
					Else
						showPage2=showPage2&"<span>"&p&"</span> "
					End if
				next
			End if
		End if
		
		if page+1<=pagecount then
			showPage2=showPage2&"<span><a href='"&url&"?page="&page+1&"'>下一页</a></span> "
		else
			showPage2=showPage2&"<span>下一页</span> "
		end If
		
		If page<pagecount then
			showPage2=showPage2&"<span><a href='"&url&"?page="&pagecount&"'>末页</a></span></div>"
		Else
			showPage2=showPage2&"<span>末页</span></div>"
		End If
	
		if instr(url,"?")<>0 Then
			showPage2=Replace(showPage2,"?page=","&page=")
		end if
end Function
'**************************************************
'函数名：SendMail
'作  用：用Jmail组件发送邮件
'参  数：MailtoAddress  ----收信人地址
'        MailtoName    -----收信人姓名
'        Subject       -----主题
'        MailBody      -----信件内容
'        FromName      -----发信人姓名
'        MailFrom      -----发信人地址
'        Priority      -----信件优先级
'**************************************************
function SendMail(MailtoAddress,Subject,htmlBody)
	On Error Resume Next
    Set objJmail = Server.CreateObject("Jmail.Message")
	if err.number<>0 then
		SendMail="Err" '没有安装jmail组件
		err.clear
		exit function
	end if
	objJMail.Charset="utf-8"          '邮件编码
	'objJMail.ContentType = "text/html"     '邮件正文格式
    '调试设置
    objJmail.Logging = true
    objJmail.Silent = true
    
    'SMTP帐号设置
    objJmail.MailServerUserName = mailAccount
    objJmail.MailServerPassWord = mailPassword

    objJmail.AddRecipient MailtoAddress,""

    objJmail.From = mailAddress
    objJmail.FromName = ""
    objJmail.ReplyTo = mailAddress
	
	textBody="您的邮箱不支持HTML格式！请打开支持HTML格式功能查看内容。"

    objJmail.Subject = Subject    
	objJmail.Body = textBody
	objJmail.HTMLBody = htmlBody
	
	objJMail.Priority=3              '邮件等级，1为加急，3为普通，5为低级

    objJmail.Send(mailSMTP)

	if err.number<>0 then
		SendMail="N"
		else
		SendMail="Y"		
	end If

	'response.write objJmail.Log
	objJMail.Close
	Set objJMail=nothing
end function
%>