<%
    Function FormatStr(String)
      ' Replaces a double carrige return with a paragraph break
      ' a single carrige return with a break rule and CHR(13) with nothing
      String = Replace(String, CHR(13), "")
      String = Replace(String, CHR(10) & CHR(10), "</P><P>")
      String = Replace(String, CHR(10), "<BR>")
      FormatStr = String
    End Function

' ---------- Page Variables ----------
    Const intCharToShow = 19		' The number of characters shown in each day
    Const bolEditable   = True		' If the calendar is editable or not (Can be tied into password verification)

    Dim dtCurrentDate			' The current date
    Dim aCalendarDays(42)		' Array of possible calendar dates
    Dim iFirstDayOfMonth		' The first day of the month
    Dim iDaysInMonth	 		' The number of days in the month
    Dim iColumns, iRows	, iDay, iWeek	' The numer of columns and rows in the table, and counters to print them
    Dim conn, strConn, strSQL, objRS ' Database Variables
    Dim counter 			' Loop counter
    Dim strNextMonth, strPrevMonth	' The next and previous month dates
    Dim dailyMsg			' The message for the day
    Dim dtOnDay				' The current day being displayed by the loops
    Dim strPage				' The link that each day takes you too

' ---------- Variable Definitions ----------
	If Request("DateYear")="" Then
	DateYear=Year(Date())
	else
    DateYear=Request("DateYear")
	End if
	If Request("DateMon")="" Then
    DateMon=Month(Date())
	else
    DateMon=Request("DateMon")
	End if
    DateDay=Day(Date())

    dtCurrentDate =DateYear&"-"&DateMon&"-"&DateDay

    iFirstDayOfMonth = DatePart("w", DateSerial(Year(dtCurrentDate), Month(dtCurrentDate), 1))
    iDaysInMonth = DatePart("d", DateSerial(Year(dtCurrentDate), Month(dtCurrentDate)+1, 1-1))

    For counter = 1 to iDaysInMonth
      aCalendarDays(counter + iFirstDayOfMonth - 1) = counter
    Next

    iColumns = 7
    iRows    = 6 - Int((42 - (iFirstDayOfMonth + iDaysInMonth)) / 7)

    strPrevMonth = Server.URLEncode(DateAdd("m", -1, dtCurrentDate))
    strNextMonth = Server.URLEncode(DateAdd("m",  1, dtCurrentDate))

' ---------- Drawing the Calendar ----------
%>

<TABLE CELLSPACING=1 CELLPADDING=2 BORDER=0 WIDTH='99%' align='center'>
<FORM NAME="pageForm" ACTION="" METHOD="GET">
  	  <TR >
  	    <TD COLSPAN=7 background="images/menu_bg.gif">
	      <SELECT NAME="DateYear" onChange="pageForm.submit()">
            <% For YearF=1970 to 2030%>
	        <OPTION VALUE="<%=YearF%>" <% If Int(YearF)=Int(DateYear) Then Response.Write "SELECTED"%>><%=YearF%></OPTION>
	      <% Next %>
	      </SELECT>
	      <SELECT NAME="DateMon" onChange="pageForm.submit()">
            <% For MonF=1 to 12%>
	        <OPTION VALUE="<%=MonF%>" <% If Int(MonF)=Int(DateMon) Then Response.Write "SELECTED"%>><%=MonF%></OPTION>
	      <% Next %>
	      </SELECT>
            </TD>
          </TR>
	  <!-- Writring the days of the week for headers -->
          <TR VALIGN="TOP" ALIGN="CENTER" >
            <% For iDay = vbSunday To vbSaturday %>
            <TD class="names"><%= WeekDayName(iDay, True) %></TD>
            <% Next %>
          </TR>
<% For iWeek = 1 To iRows
      Response.Write "<TR VALIGN=TOP >"
      For iDay = 1 To iColumns
	' Checks to see if there is a day this month on the date being written
	If aCalendarDays((iWeek-1)*7 + iDay) > 0 then
	  dtOnDay = DateSerial(Year(dtCurrentDate), Month(dtCurrentDate), aCalendarDays((iWeek-1)*7 + iDay))
      dtToday = Date()
	  ' Checks to see if the day being printed is today
	  If dtOnDay = dtToday Then
	    Response.Write "<TD CLASS='calCurrentDay' bgcolor='#ddeeff'>"
 	  Else
   	    Response.Write "<TD CLASS='calOtherDay' bgcolor='#ffffff' style='BORDER: #ddeeff 1px solid;'>"
 	  End If

	  ' Checks to see the type of calendar (editable or non-editable)
 	  If (bolEditable) then
   	    strPage = "updateCalendar_form.asp?currentDate=" & dtOnDay
 	  Else
   	    strPage = "viewDay.asp?currentDate=" & dtOnDay
	  End If

	  ' Checks for a message on the day being written
	  strSQL = "SELECT * FROM Plan_calendar WHERE calendarDate =#"&dtOnDay&"# "
	  Set objRS = conn.Execute(strSQL)
	  Dim dateid,flag
	  If NOT objRS.EOF Then
	    dailyMsg = objRS("calendarText")
		dateid = objRS("id")
		flag = objRS("calendarFlag")
	  Else
	    dailyMsg = ""
	  End If


	  Set objRS = Nothing

	  ' Checks to see if the message is too long to be displayed in the mini date box
          If (Trim(dailyMsg) = Trim(Left(dailyMsg, intCharToShow))) Then
	  Else
	     dailyMsg = Trim(Left(dailyMsg, intCharToShow-4)) & " ..."
          End If

Response.Write ("<i><b><A HREF=viewday.asp?currentDate=" & dtOnDay & " title='鿴ȫϸ' target='_blank'><FONT  COLOR=#FF9900>"&aCalendarDays((iWeek-1)*7 + iDay)&"</FONT></A></b></i>&nbsp;<A HREF=" & strPage & " title='˵ӻ޸ĵ' target='_blank'><IMG SRC=images/icon_add.gif BORDER=0 ALT=˵ӻ޸ĵ></A>")
'ʾ⣬ȼ-----------------------------------------------------------
set RS=server.createobject("adodb.recordset")
SQL="select * from Plan_calendar where calendarDate=#"&dtOnDay&"# order by calendarHour"
rs.open sql,conn,1,1
%>
<BR>
<%
for ForDate=1 to rs.recordcount
%>
<A HREF="viewday.asp?currentDate=<%=dtOnDay%>" title='<%=RS("calendartext")%>'><B><%=rs("calendarHour")%>.</B><%=RS("calendartitle")%></A><BR>
<%
rs.moveNext
next
rs.close
	Else
	  Response.Write ("<TD  CLASS='calNotDay'>&nbsp;")
	End IF

%>
<%Response.Write "</TD>"
      Next
      Response.Write "</TR>"
    Next

%>
</FORM>
</TABLE>
