module.exports={
  baseInfo:{
    title:'基本信息',
    name:'baseInfo',
    valid:false,
    fields:{
      first_name_cn:{
        name:'first_name_cn',
        label:'姓(中文)',
        type:'InputBox', inputType:'text',
        value:'',
        pattern:'^[\\u4e00-\\u9fa5]+$',
        require:true
      },
      second_name_cn:{
        name:'second_name_cn',
        label:'名(中文)',
        type:'InputBox', inputType:'text',
        value:'',
        pattern:'^[\\u4e00-\\u9fa5]+$',
        require:true
      },
      first_name_en:{
        name:'first_name_en',
        label:'姓(拼音)',
        type:'InputBox', inputType:'text',
        onKeyup:'',
        value:'',
        pattern:'^[a-zA-Z]+$',
        require:true
      },
      second_name_en:{
        name:'second_name_en',
        label:'名(拼音)',
        type:'InputBox', inputType:'text',
        onKeyup:'',
        value:'',
        pattern:'^[a-zA-Z]+$',
        require:true
      },
      old_name:{
        name:'old_name',
        label:'曾用名',
        type:'SelectBox',
        values:[
          {label:'有',value:'1'},
          {label:'无',value:'0'}
        ],
        value:0,
        require:true
      },
      old_name_cn:{
        name:'old_name_cn',
        label:'曾用姓名(中文)',
        type:'InputBox',
        inputType:'text',
        className:'level2',
        value:'',
        pattern:'^[\\u4e00-\\u9fa5]{2,}$',
        showWhile:[
          {key:'old_name',value:'1'}
        ],
        require:true
      },
      old_name_en:{
        name:'old_name_en',
        label:'曾用姓名(拼音)',
        type:'InputBox',
        inputType:'text',
        value:'',
        pattern:'^[a-zA-Z\\s]+$',
        className:'level2',
        showWhile:[
          {key:'old_name',value:'1'}
        ],
        onKeyup:'',
        require:true
      },
      gender:{
        name:'gender',
        label:'性别',
        type:'SelectBox',
        values:[
          {label:'男',value:'0'},
          {label:'女',value:'1'}
        ],
        value:0,
        require:true
      },
      marry:{
        name:'marry',
        label:'婚姻状况',
        type:'SelectBox',
        values:[
          {label:'单身',value:'1'},
          {label:'已婚',value:'2'},
          {label:'离异',value:'3'},
          {label:'丧偶',value:'4'}
        ],
        value:1,
        require:true
      },
      birthday:{
        name:'birthday',
        label:'出生日期',
        type:'DateBox',
        value:'',
        require:true
      },
      birth_place:{
        name:'birth_place',
        label:'出生地点',
        type:'SelectBox',
        values:'与护照上保持一致',
        placeholder:'',
        hideDistrict:1,
        value:'',
        require:true
      },
      birth_place2:{
        name:'birth_place2',
        label:'其它地点',
        type:'InputBox',
        inputType:'text',
        placeholder:'',
        value:'',
        require:true,
        className:'level2',
        showWhile:[
          {key:'birth_place',value:'其它'}
        ]
      }
    }
  },

  cardInfo:{
    title:'证件信息',
    name:'cardInfo',
    valid:false,
    fields:{
      id_no:{
        name:'id_no',
        label:'身份证号码',
        type:'InputBox',
        inputType:'text',
        placeholder:'',
        pattern:'^\\d{15}$|^\\d{17}\\S$',
        value:'',
        maxLength:18,
        require:true
      },
      passport_number:{
        name:'passport_number',
        label:'护照号码',
        type:'InputBox',
        inputType:'text',
        onKeyup:'',
        placeholder:'',
        pattern:'^\\S+\\d+$',
        value:'',
        require:true
      },
      issue_place_cn:{
        name:'issue_place_cn',
        label:'签发地点',
        type:'SelectBox',
        values:'',
        value:'',
        pattern:'^\\S+$',
        require:true
      },
      other_issue_place_cn:{
        name:'other_issue_place_cn',
        label:'其它地点',
        type:'InputBox',
        inputType:'text',
        placeholder:'请输入地点名称',
        pattern:'^\\S+$',
        value:'',
        showWhile:[
          {key:'issue_place_cn',value:'其它'}
        ],
        require:true
      },
      ps_issue_date:{
        name:'ps_issue_date',
        label:'签发日期',
        type:'DateBox',
        value:'',
        pattern:'^\\S+$',
        require:true
      },
      ps_expire_date:{
        name:'ps_expire_date',
        label:'有效日期',
        type:'DateBox',
        value:'',
        pattern:'^\\S+$',
        require:true
      },
      issue_authority_cn:{
        name:'issue_authority_cn',
        label:'签发机关',
        type:'InputBox',
        inputType:'text',
        value:'',
        pattern:'^\\S+$',
        placeholder:'比如：公安部出入境管理局',
        require:true
      }
    }
  },

  familyAndWork:{
    title:'家庭与职业信息',
    name:'familyAndWork',
    valid:false,
    fields:{
      home_address:{
        name:'home_address',
        label:'居住地址',
        type:'CityPicker',
        placeholder:'省市区',
        value:'',
        require:true
      },
      home_street:{
        name:'home_street',
        label:'详细地址',
        type:'InputBox', inputType:'text',
        value:'',
        pattern:'^\\S+$',
        className:'level2',
        placeholder:'精确到门牌号',
        require:true
      },
      home_mobile:{
        name:'home_mobile',
        label:'手机号码',
        type:'InputBox',
        inputType:'tel',
        placeholder:'儿童请填写父母手机',
        value:'',
        pattern:'^1\\d{10}$',
        maxLength:11,
        require:true
      },
      work:{
        name:'work',
        label:'工作单位',
        type:'InputBox',
        inputType:'text',
        value:'无',
        pattern:'^\\S+$',
        placeholder:'',
        require:false
      },
      work_phone:{
        name:'work_phone',
        label:'单位电话',
        type:'InputBox',
        inputType:'text',
        value:'',
        pattern:'^(\\d+(\-\\d+)?)$',
        placeholder:'',
        require:false
      },
      work_address:{
        name:'work_address',
        label:'单位地址',
        type:'CityPicker',
        placeholder:'省市区',
        value:'',
        require:false
      },
      work_street:{
        name:'work_street',
        label:'详细地址',
        type:'InputBox',
        inputType:'text',
        className:'level2',
        value:'',
        pattern:'^\\S+$',
        placeholder:'',
        require:false
      },
      job:{
        name:'job',
        label:'当前职位',
        type:'InputBox',
        inputType:'text',
        value:'',
        pattern:'^\\S+$',
        placeholder:'',
        require:false
      },
      mate_job:{
        name:'mate_job',
        label:'配偶职位',
        type:'InputBox',
        inputType:'text',
        value:'',
        pattern:'^\\S+$',
        placeholder:'',
        require:true,
        showWhile:[
          {key:'marry',value:'2'}
        ]
      },
      parent_job:{
        name:'parent_job',
        label:'父母职位',
        type:'InputBox',
        inputType:'text',
        value:'',
        pattern:'^\\S+$',
        placeholder:'',
        require:true,
        display:false,
        showWhile:[
          {key:'marry',values:['1','3','4']},
          {key:'birthday',func:function (m) {
            if(getAge(m)<18){
              return true;
            }else{
              return false;
            }
          }}
        ]
      }

    }
  },

  ugentInfo:{
    title:'紧急联系人(同行人不可以作为紧急联系人)',
    name:'ugentInfo',
    valid:false,
    fields:{
      jjjj:{
        name:'',
        label:'同行人不可以作为紧急联系人',
        type:'TitleBox'
      },
      jj_name:{
        name:'jj_name',
        label:'姓名',
        type:'InputBox', inputType:'text',
        value:'',
        pattern:'^[\\u4e00-\\u9fa5]{2,}$',
        require:true,
        props:[]
      },
      jj_mobile:{
        name:'jj_mobile',
        label:'手机号码',
        type:'InputBox', inputType:'tel',
        value:'',
        pattern:'^1\\d{10}$',
        maxLength:11,
        require:true,
        props:[]
      },
      jj_together:{
        name:'jj_together',
        label:'是否跟您住一起',
        type:'SelectBox',
        values:[
          {label:'是',value:'1'},
          {label:'否',value:'0'}
        ],
        value:'',
        onChange:function(fd,sd,gd){
          if(fd==1){
            sd('jj_address',gd('home_address'));
            sd('jj_street',gd('home_street'));
          }
        },
        require:true
      },
      jj_address:{
        name:'jj_address',
        label:'现居地址',
        type:'CityPicker',
        placeholder:'省市区',
        value:'',
        require:true,
        className:'level2'
      },
      jj_street:{
        name:'jj_street',
        label:'详细地址',
        type:'InputBox', inputType:'text',
        value:'',
        pattern:'^\\S+$',
        require:true,
        placeholder:'精确到门牌号',
        className:'level2'
      },
      jj_relation:{
        name:'jj_relation',
        label:'与申请人关系',
        type:'SelectBox',
        values:[
          {label:'父子',value:'1'},
          {label:'母子',value:'2'},
          {label:'父女',value:'3'},
          {label:'母女',value:'4'},
          {label:'夫妻',value:'26'},
          {label:'兄弟',value:'5'},
          {label:'兄妹',value:'6'},
          {label:'姐弟',value:'7'},
          {label:'姐妹',value:'8'},
          {label:'表兄弟',value:'9'},
          {label:'表兄妹',value:'10'},
          {label:'表姐弟',value:'11'},
          {label:'表姐妹',value:'12'},
          {label:'堂兄弟',value:'13'},
          {label:'堂兄妹',value:'14'},
          {label:'堂姐弟',value:'15'},
          {label:'堂姐妹',value:'16'},
          {label:'嫂子',value:'17'},
          {label:'弟媳',value:'18'},
          {label:'姐夫',value:'19'},
          {label:'妹夫',value:'20'},
          {label:'叔侄',value:'21'},
          {label:'舅侄',value:'22'},
          {label:'姑甥',value:'23'},
          {label:'姨甥',value:'24'},
          {label:'祖孙',value:'25'}
        ],
        value:'',
        require:true,
        props:[]
      },
      jj_relation_other:{
        name:'jj_relation_other',
        label:'其它关系',
        type:'InputBox', inputType:'text',
        value:'',
        pattern:'^\\S+$',
        require:true,
        className:'level2',
        showWhile:[
          {key:'jj_relation',value:'0'}
        ]
      }
    }
  },

  otherInfo:{
    title:'其它信息',
    name:'otherInfo',
    valid:false,
    fields:{
      target:{
        name:'target',
        label:'访问目的',
        type:'SelectBox',
        values:[
          {label:'旅游',value:'1'},
          {label:'商务',value:'2'}
        ],
        value:'',
        require:true
      },
      kouan:{
        name:'kouan',
        label:'入境口岸',
        type:'SelectBox',
        values:[
          {label:'东京',value:'东京'},
          {label:'大阪',value:'大阪'},
          {label:'名古屋',value:'名古屋'},
          {label:'福冈',value:'福冈'},
          {label:'札幌',value:'札幌'},
          {label:'北海道',value:'北海道'}
        ],
        value:'',
        require:true
      },
      reach:{
        name:'reach',
        label:'预定在日停留日期',
        type:'DateBox',
        value:'',
        pattern:'^\\S+$',
        require:true,
        placeholder:'开始时间'
      },
      reach2:{
        name:'reach2',
        label:'至',
        className:'label_right level2',
        type:'DateBox',
        value:'',
        pattern:'^\\S+$',
        require:true,
        placeholder:'结束时间'
      },
      ever_go:{
        name:'ever_go',
        label:'曾经是否去过日本?',
        type:'SelectBox',
        values:[
          {label:'是',value:'1'},
          {label:'否',value:'0'}
        ],
        value:'',
        pattern:'^\\S+$',
        require:true,
        props:[]
      },
      ever_date:{
        name:'ever_date',
        label:'上次赴日日期',
        type:'DateBox',
        value:'',
        pattern:'^\\S+$',
        require:true,
        placeholder:'',
        className:'level2',
        showWhile:[
          {key:'ever_go',values:['1','2']}
        ]
      },
      ever_duration:{
        name:'ever_duration',
        label:'上次赴日停留时间?',
        type:'SelectBox',
        values:0,
        value:'',
        pattern:'^\\S+$',
        className:'level2',
        require:true,
        showWhile:[
          {key:'ever_go',values:['1','2']}
        ]
      },
      guilt:{
        name:'guilt',
        label:'在任何国家曾被判决有罪?',
        type:'SelectBox',
        values:[
          {label:'是',value:'1'},
          {label:'否',value:'0'}
        ],
        value:'',
        pattern:'^\\S+$',
        require:true,
        props:[]
      }
    }
  }
}