# Documentation Comment Syntax

Documentation comments in Swift use Markdown-flavored markup syntax. Swift doc
comments utilize a full-fledged [CommonMark] parser library (known as [swift-cmark] in
the Swift projects), which is rendered in Xcode QuickHelp.

[CommonMark]: http://commonmark.org
[cmark]: https://github.com/apple/swift-cmark

Swift Markup syntax is *exactly* CommonMark, *by design*, not only for its
straightforward implementation and completeness but also in the spirit of
Markdown's readability through limited special syntax.

In addition to full Markdown support, the following extensions are supported via
interpretation only after the CommonMark parser has finished with the doc
comment block. These appear as list items at the top level of the comment's
"document". The goal of these "extensions" was *zero changes* to the *cmark*
library. Because they are regular list items, you may nest arbitrary content
underneath them, such as multiple paragraphs, sublists, hyperlinks, etc. and
they will be rendered in QuickHelp correctly.

All of the below extension "keywords" are matched without regard to case.

## Parameters

There are two methods of documenting parameters: a `Parameters Section` and
separate `Parameter` Fields. You can mix and match these forms as you see fit in
any order or continuity throughout the doc comment.

### Parameters Section

    - Parameters:
      - x: ...
      - y: ...
      - z: ...

### Separate Parameter Fields

    - Parameter x: ...
    - Parameter y: ...

## Returns Field

This field documents the return value of a function or method. You may specify
multiple `Returns` items at the top level but only the last one will be
shown in Xcode's QuickHelp.

    - Returns: ...

## Throwing Functions

Functions that are marked as `Throws` should contain the following describing
what kind of errors are thrown and in what situations:

    - Throws: ...

## Field Extensions

These extensions are also list items at the top level, which will also appear
highlighted in Xcode QuickHelp as first-class citizens.  Specifying more than
one is supported and appear in order inside QuickHelp.

    - Attention: ...
    - Author: ...
    - Authors: ...
    - Bug: ...
    - Complexity: ...
    - Copyright: ...
    - Date: ...
    - Experiment: ...
    - Important: ...
    - Invariant: ...
    - Note: ...
    - Postcondition: ...
    - Precondition: ...
    - Remark: ...
    - Remarks: ...
    - Requires: ...
    - See: ...
    - Since: ...
    - Todo: ...
    - Version: ...
    - Warning: ...

## Other documentation

You can find more information on the visual effects of the documentation comments
in Xcode's QuickHelp at the [Markup Formatting Reference].

[Markup Formatting Reference]: https://developer.apple.com/library/mac/documentation/Xcode/Reference/xcode_markup_formatting_ref
