//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2018 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// NOTE: older overlays had Network.NWProtocolTLS as the ObjC name.
// The two must coexist, so it was renamed. The old name must not be
// used in the new runtime. _TtC7Network14_NWProtocolTLS is the
// mangled name for Network._NWProtocolTLS.
@_objcRuntimeName(_TtC7Network14_NWProtocolTLS)
@available(macOS 10.14, iOS 12.0, watchOS 5.0, tvOS 12.0, *)
public class NWProtocolTLS : NWProtocol {
	public static let definition: NWProtocolDefinition = {
		NWProtocolDefinition(nw_protocol_copy_tls_definition(), "tls")
	}()

  // Set the ObjC name of this class to be nested in the customized ObjC
  // name of NWProtocolTLS.
  @_objcRuntimeName(_TtCC7Network14_NWProtocolTLS7Options)
	public class Options : NWProtocolOptions {
		/// Access the sec_protocol_options_t for a given network protocol
		/// options instance. See <Security/SecProtocolOptions.h> for functions
		/// to further configure security options.
		public var securityProtocolOptions: sec_protocol_options_t {
			return nw_tls_copy_sec_protocol_options(self.nw)
		}

		/// Create TLS options to set in an NWParameters.ProtocolStack
		public init() {
			super.init(nw_tls_create_options())
		}

		override internal init(_ nw: nw_protocol_options_t) {
			super.init(nw)
		}
	}

	/// Access TLS metadata using NWConnection.metadata(protocolDefinition: NWProtocolTLS.definition)
	/// or in received ContentContext
  // Set the ObjC name of this class to be nested in the customized ObjC
  // name of NWNWProtocolTLSProtocolIP.
  @_objcRuntimeName(_TtCC7Network14_NWProtocolTLS8Metadata)
	public class Metadata: NWProtocolMetadata {
		/// Access the sec_protocol_metadata_t for a given network protocol
		/// metadata instance. See <Security/SecProtocolMetadata.h> for functions
		/// to further access security metadata.
		public var securityProtocolMetadata: sec_protocol_metadata_t {
			return nw_tls_copy_sec_protocol_metadata(self.nw)
		}

		override internal init(_ nw: nw_protocol_metadata_t) {
			super.init(nw)
		}
	}
}
