**DO NOT READ THIS FILE ON GITHUB, GUIDES ARE PUBLISHED ON https://guides.rubyonrails.org.**

Action Text Overview
====================

This guide provides you with all you need to get started in handling
rich text content.

After reading this guide, you will know:

* How to configure Action Text.
* How to handle rich text content.
* How to style rich text content.

--------------------------------------------------------------------------------

Introduction
------------

Action Text brings rich text content and editing to Rails. It includes
the [Trix editor](https://trix-editor.org) that handles everything from formatting
to links to quotes to lists to embedded images and galleries.
The rich text content generated by the Trix editor is saved in its own
RichText model that's associated with any existing Active Record model in the application.
Any embedded images (or other attachments) are automatically stored using
Active Storage and associated with the included RichText model.

## Trix compared to other rich text editors

Most WYSIWYG editors are wrappers around HTML’s `contenteditable` and `execCommand` APIs,
designed by Microsoft to support live editing of web pages in Internet Explorer 5.5,
and [eventually reverse-engineered](https://blog.whatwg.org/the-road-to-html-5-contenteditable#history)
and copied by other browsers.

Because these APIs were never fully specified or documented,
and because WYSIWYG HTML editors are enormous in scope, each
browser's implementation has its own set of bugs and quirks,
and JavaScript developers are left to resolve the inconsistencies.

Trix sidesteps these inconsistencies by treating contenteditable
as an I/O device: when input makes its way to the editor, Trix converts that input
into an editing operation on its internal document model, then re-renders
that document back into the editor. This gives Trix complete control over what
happens after every keystroke, and avoids the need to use execCommand at all.

## Installation

Run `rails action_text:install` to add the Yarn package and copy over the necessary migration.

## Examples

Adding a rich text field to an existing model:

```ruby
# app/models/message.rb
class Message < ApplicationRecord
  has_rich_text :content
end
```

Then refer to this field in the form for the model:

```erb
<%# app/views/messages/_form.html.erb %>
<%= form_with(model: message) do |form| %>
  <div class="field">
    <%= form.label :content %>
    <%= form.rich_text_area :content %>
  </div>
<% end %>
```

And finally display the sanitized rich text on a page:

```erb
<%= @message.content %>
```

To accept the rich text content, all you have to do is permit the referenced attribute:

```ruby
class MessagesController < ApplicationController
  def create
    message = Message.create! params.require(:message).permit(:title, :content)
    redirect_to message
  end
end
```

## Custom styling

By default, the Action Text editor and content is styled by the Trix defaults.
If you want to change these defaults, you'll want to remove
the `app/assets/stylesheets/actiontext.css` linker and base your stylings on
the [contents of that file](https://raw.githubusercontent.com/basecamp/trix/master/dist/trix.css).

You can also style the HTML used for embedded images and other attachments (known as blobs).
On installation, Action Text will copy over a partial to
`app/views/active_storage/blobs/_blob.html.erb`, which you can specialize.
