<p align="center">
  <img src="https://raw.githubusercontent.com/QMUI/QMUIDemo_Web/master/public/style/images/independent/BannerForGithub_2x.png" width="220" alt="Banner" />
</p>

# QMUI Web [![Version Number](https://img.shields.io/npm/v/generator-qmui.svg?style=flat)](https://github.com/Tencent/QMUI_Web/ "Version Number")
> A front-end framework to make web UI development faster and easier.
>
> Official Website：[http://qmuiteam.com/web](http://qmuiteam.com/web)
>
> Demo：[https://github.com/QMUI/QMUIDemo_Web/releases](https://github.com/QMUI/QMUIDemo_Web/releases)

[[English]](https://github.com/Tencent/QMUI_Web/tree/master/docs-translations/en-US/README.md) / [[简体中文]](https://github.com/Tencent/QMUI_Web/blob/master/README.md) / [[繁體中文]](//github.com/Tencent/QMUI_Web/tree/master/docs-translations/zh-TW/README.md)

[![Build Status](https://travis-ci.org/Tencent/QMUI_Web.svg?branch=master)](https://travis-ci.org/Tencent/QMUI_Web "Build Status")
[![Build status](https://ci.appveyor.com/api/projects/status/1h6de3rq6x45nnse?svg=true
)](https://ci.appveyor.com/project/kayo5994/qmui-web)
[![devDependencies](https://img.shields.io/david/dev/QMUI/qmui_web.svg?style=flat)](https://ci.appveyor.com/project/QMUI/qmui_web "devDependencies")
[![QMUI Team Name](https://img.shields.io/badge/Team-QMUI-brightgreen.svg?style=flat)](https://github.com/QMUI "QMUI Team")
[![License](https://img.shields.io/badge/license-MIT-blue.svg?style=flat)](http://opensource.org/licenses/MIT "Feel free to contribute.")

This framework consists of a collection of SASS methods and a built-in workflow, which can help you easily improve the efficiency, maintainability and robustness of your web UI development. Especially, when you want to adjust appearance of your website globally or deal with frequent UI design alteration, QMUI Web will be your best choice.

## Features

### Components and Configuration
You can easily adjust global appearance of basic built-in components by editing a SASS config file. （[How do QMUI config file and basic components contribute to your UI development?](https://github.com/Tencent/QMUI_Web/wiki/Q&A#qmui-sass-%E9%85%8D%E7%BD%AE%E8%A1%A8%E5%92%8C%E5%85%AC%E5%85%B1%E7%BB%84%E4%BB%B6%E5%A6%82%E4%BD%95%E5%B8%AE%E5%BF%99%E5%BC%80%E5%8F%91%E8%80%85%E5%BF%AB%E9%80%9F%E6%90%AD%E5%BB%BA%E9%A1%B9%E7%9B%AE%E5%9F%BA%E7%A1%80-ui)）

### SASS Enhancement
QMUI Web ships with more than 70 SASS Mixin, Function and Extend, dealing with layout, appearance, animation, device adaptation, math calculation and other SASS enhancement, which will make your development faster and easier.
### Automatic Processing
QMUI Web has a built-in workflow and tools to automate a lot of work, including the Sprite image, html template engine, image management and compression, static resource merging and compression, and redundant file cleanup.

### Extended Component
In addition to the built-in basic components, we also provide several extended components such as file upload button, tree menu, etc.

## Setup
ure to install [Node.js](https://nodejs.org/) (recommend 6.0 or later) and then install Gulp globally with the following command:

```bash
#Install gulp
npm install --global gulp
```
## Getting Started
It is recommend for you to use a [Yeoman](http://yeoman.io/) project named [generator-qmui](https://github.com/QMUI/generator-qmui) to install and configure QMUI Web.

```bash
#Install Yeoman. If you have already installed, please ignore this step.
npm install -g yo
#Install QMUI Template
npm install -g generator-qmui
#Execute the following command in the root directory of the project
yo qmui
```
<img src="https://raw.githubusercontent.com/QMUI/qmuidemo_web/master/public/style/images/independent/Generator.gif" width="628" alt="效果预览" />

### Project Structure Generated After Completion
```bash
Root Directory
├─public          // Static resource directory, generated by gulp
│  ├─js           // Javascript
│  └─style        // All UI files generate here
│     ├─css       // All styles files generate here
│     └─images    // Images generate here
├─UI_dev          // Development directory
│  ├─project      // SASS and images files
│  │  ├─images    // Image source directory
│  │  ├─logic     // SASS file of each module
│  │  └─widget    // SASS file of components
│  └─qmui_web     // QMUI Web Source Code
├─UI_html         // HTML files
└─UI_html_result  // HTML files compiled by gulp
```

If you need more customization, please refer to [Creating Project (Advanced)](http://qmuiteam.com/web/page/start.html#qui_createProject)

## Task List in Build-In Workflow

```bash
gulp list
```

## Make Contributions
You can create [issues](https://github.com/Tencent/QMUI_Web/issues) or send [pull requests](https://github.com/Tencent/QMUI_Web/pulls) if you have any feedback or suggestion.
Please read the [documentation](http://qmuiteam.com/web/page/start.html#qui_frameworkImprove) before debugging or modifying this framework.

Thanks very much for your support and contributions.

Design file (Sketch) is available on [Dribbble](https://dribbble.com/shots/2895907-QMUI-Logo).

## QMUI Web Desktop

If you prefer visual interface rather than CLI, it is recommended to try an additional desktop application: [QMUI Web Desktop](https://github.com/Tencent/QMUI_Web_desktop). You can manage projects based on QMUI Web, toggle QMUI Web services, and get compilation or error message in time through it.

<img src="https://raw.githubusercontent.com/QMUI/QMUIDemo_Web/master/public/style/images/independent/App_2x.png" width="440" alt="QMUI Web Desktop" />
