/*
 * Decompiled with CFR 0.152.
 */
package org.yx.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.yx.asm.MethodInfoClassVisitor;
import org.yx.common.MethodInfo;
import org.yx.rpc.server.intf.ActionContext;

public final class AsmUtils {
    private static String[] blanks = new String[]{"getClass", "wait", "equals", "notify", "notifyAll", "toString", "hashCode"};
    private static Map<String, Class<?>> clzMap;
    private static Map<Class<?>, Method> loaderDefinds;
    public static final int BADMODIFIERS = 1050;

    public static String proxyCalssName(Class<?> clz) {
        String name = clz.getName();
        int index = name.lastIndexOf(".");
        return name.substring(0, index) + ".sumkbox" + name.substring(index);
    }

    private static ClassLoader loader() {
        ClassLoader load = Thread.currentThread().getContextClassLoader();
        if (load != null) {
            return load;
        }
        return AsmUtils.class.getClassLoader();
    }

    public static InputStream openStreamForClass(String name) {
        String internalName = name.replace('.', '/') + ".class";
        return AsmUtils.loader().getResourceAsStream(internalName);
    }

    public static boolean isFilted(String method) {
        for (String m : blanks) {
            if (!m.equals(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean sameType(Type[] types, Class<?>[] clazzes) {
        if (types.length != clazzes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (Type.getType(clazzes[i]).equals((Object)types[i])) continue;
            return false;
        }
        return true;
    }

    public static Class<?> CreateArgPojo(String clzName, MethodInfo p) throws Exception {
        String fullName = clzName + "_" + p.getMethod().getName();
        if (p.getArgNames() == null || p.getArgNames().length == 0) {
            return null;
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(52, 1, fullName.replace('.', '/'), null, "java/lang/Object", null);
        Class<?>[] argTypes = p.getMethod().getParameterTypes();
        int argCount = 0;
        for (int i = 0; i < p.getArgNames().length; ++i) {
            if (ActionContext.class.isInstance(argTypes[i])) continue;
            ++argCount;
            String arg = p.getArgNames()[i];
            String desc = p.getDescs()[i];
            cw.visitField(1, arg, desc, p.getSignatures()[i], null).visitEnd();
        }
        cw.visitEnd();
        if (argCount == 0) {
            return null;
        }
        byte[] b = cw.toByteArray();
        return AsmUtils.loadClass(fullName, b);
    }

    public static MethodInfo createMethodInfo(String classFullName, Method m) throws IOException {
        ClassReader cr = new ClassReader(AsmUtils.openStreamForClass(classFullName));
        MethodInfoClassVisitor cv = new MethodInfoClassVisitor(m);
        cr.accept((ClassVisitor)cv, 0);
        return new MethodInfo(m, cv.argNames.toArray(new String[0]), cv.descriptor, cv.signatures.toArray(new String[0]));
    }

    public static Method getMethod(Class<?> clz, String methodName, Class<?>[] paramTypes) {
        while (clz != Object.class) {
            Method[] ms;
            for (Method m : ms = clz.getDeclaredMethods()) {
                Object[] paramTypes2;
                if (!m.getName().equals(methodName) || !Arrays.equals(paramTypes2 = m.getParameterTypes(), paramTypes)) continue;
                return m;
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadClass(String fullName, byte[] b) throws Exception {
        Class clz;
        if (clzMap == null) {
            clzMap = new ConcurrentHashMap();
        }
        if ((clz = clzMap.get(fullName)) != null) {
            return clz;
        }
        Class<AsmUtils> clazz = AsmUtils.class;
        synchronized (AsmUtils.class) {
            clz = clzMap.get(fullName);
            if (clz != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return clz;
            }
            Class<?> loaderClz = AsmUtils.loader().getClass();
            Method defineClass = loaderDefinds.get(loaderClz);
            if (defineClass == null) {
                defineClass = AsmUtils.getMethod(loaderClz, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
                defineClass.setAccessible(true);
                loaderDefinds.put(loaderClz, defineClass);
            }
            if ((clz = (Class)defineClass.invoke((Object)AsmUtils.loader(), fullName, b, 0, b.length)) == null) {
                throw new Exception("cannot load class " + fullName);
            }
            clzMap.put(fullName, clz);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return clz;
        }
    }

    public static boolean notPublicOnly(int modifiers) {
        return (modifiers & 1) == 0 || (modifiers & 0x41A) != 0;
    }

    public static boolean canProxy(int modifiers) {
        return (modifiers & 0x41A) == 0;
    }

    public static List<Object> getImplicitFrame(String desc) {
        ArrayList<Object> locals = new ArrayList<Object>(5);
        if (desc.isEmpty()) {
            return locals;
        }
        int i = 0;
        while (desc.length() > i) {
            int j = i;
            switch (desc.charAt(i++)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    locals.add(Opcodes.INTEGER);
                    break;
                }
                case 'F': {
                    locals.add(Opcodes.FLOAT);
                    break;
                }
                case 'J': {
                    locals.add(Opcodes.LONG);
                    break;
                }
                case 'D': {
                    locals.add(Opcodes.DOUBLE);
                    break;
                }
                case '[': {
                    while (desc.charAt(i) == '[') {
                        ++i;
                    }
                    if (desc.charAt(i) == 'L') {
                        ++i;
                        while (desc.charAt(i) != ';') {
                            ++i;
                        }
                    }
                    locals.add(desc.substring(j, ++i));
                    break;
                }
                case 'L': {
                    while (desc.charAt(i) != ';') {
                        ++i;
                    }
                    locals.add(desc.substring(j + 1, i++));
                    break;
                }
            }
        }
        return locals;
    }

    public static Method proxyMethod(Method method, Class<?> proxyedClass) {
        Method[] proxyedMethods;
        Class<?> clz = method.getDeclaringClass();
        if (clz == proxyedClass) {
            return method;
        }
        String methodName = method.getName();
        Object[] argTypes = method.getParameterTypes();
        for (Method proxyedMethod : proxyedMethods = proxyedClass.getDeclaredMethods()) {
            if (!proxyedMethod.getName().equals(methodName) || !Arrays.equals(argTypes, proxyedMethod.getParameterTypes())) continue;
            return proxyedMethod;
        }
        return method;
    }

    static {
        loaderDefinds = new HashMap();
    }
}

