/*
 * Decompiled with CFR 0.152.
 */
package org.yx.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.yx.asm.AsmUtils;
import org.yx.log.Log;

public class MethodInfoClassVisitor
extends ClassVisitor {
    public final List<String> argNames;
    public final List<String> signatures;
    public String[] descriptor;
    private final Method m;

    public MethodInfoClassVisitor(Method m) {
        super(327680);
        this.m = m;
        Type[] tys = Type.getArgumentTypes((Method)m);
        this.argNames = new ArrayList<String>(tys.length);
        this.signatures = new ArrayList<String>(tys.length);
        this.descriptor = new String[tys.length];
        for (int i = 0; i < tys.length; ++i) {
            this.descriptor[i] = tys[i].getDescriptor();
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final Type[] args = Type.getArgumentTypes((String)desc);
        if (!name.equals(this.m.getName()) || !AsmUtils.sameType(args, this.m.getParameterTypes())) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodVisitor v = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodVisitor(327680, v){

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(name, desc, signature, start, end, index);
                int argSize = MethodInfoClassVisitor.this.m.getParameterTypes().length;
                if ("this".equals(name) || MethodInfoClassVisitor.this.argNames.size() >= argSize || MethodInfoClassVisitor.this.argNames.contains(name)) {
                    return;
                }
                int k = MethodInfoClassVisitor.this.argNames.size();
                if (!args[k].getDescriptor().equals(desc)) {
                    Log.get("sumk.SYS").error("current desc should be " + args[k].getDescriptor() + ",but really is " + desc);
                    return;
                }
                MethodInfoClassVisitor.this.argNames.add(name);
                MethodInfoClassVisitor.this.signatures.add(signature);
            }
        };
    }
}

