/*
 * Decompiled with CFR 0.152.
 */
package org.yx.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.yx.asm.AsmUtils;
import org.yx.asm.ProxyClassVistor;
import org.yx.bean.Box;
import org.yx.conf.AppInfo;
import org.yx.exception.SumkException;
import org.yx.log.Log;

public class ProxyClassFactory {
    public static Class<?> proxyIfNeed(Class<?> clz) throws Exception {
        byte[] code;
        String newClzName;
        block6: {
            Method[] bethods;
            if ("no".equals(AppInfo.get("sumk.aop.proxy", "config"))) {
                return clz;
            }
            HashMap<String, Method> aopMethods = new HashMap<String, Method>();
            for (Method m : bethods = clz.getDeclaredMethods()) {
                if (!AsmUtils.canProxy(m.getModifiers()) || m.getAnnotation(Box.class) == null || aopMethods.put(m.getName(), m) == null) continue;
                SumkException.throwException(-2321435, "the name of box method cannot duplicate in one class");
            }
            if (aopMethods.isEmpty()) {
                return clz;
            }
            ClassReader cr = new ClassReader(AsmUtils.openStreamForClass(clz.getName()));
            ClassWriter cw = new ClassWriter(cr, 1);
            newClzName = AsmUtils.proxyCalssName(clz);
            ProxyClassVistor cv = new ProxyClassVistor((ClassVisitor)cw, newClzName, clz, aopMethods);
            cr.accept((ClassVisitor)cv, 327680);
            code = cw.toByteArray();
            String clzOutPath = AppInfo.get("sumk.aop.debug.output");
            if (clzOutPath != null && clzOutPath.length() > 0) {
                try {
                    File f = new File(clzOutPath, newClzName + ".class");
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(code);
                    fos.close();
                }
                catch (Exception e) {
                    if (!Log.isTraceEnable("proxy")) break block6;
                    Log.printStack(e);
                }
            }
        }
        return AsmUtils.loadClass(newClzName, code);
    }
}

