/*
 * Decompiled with CFR 0.152.
 */
package org.yx.asm;

import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.yx.asm.AsmMethod;
import org.yx.asm.ProxyMethodWritor;
import org.yx.bean.Box;

public class ProxyClassVistor
extends ClassVisitor {
    private Class<?> orginClz;
    private Map<String, Method> aopMethods;
    private String clzName;

    public ProxyClassVistor(ClassVisitor cv, String newClzName, Class<?> clz, Map<String, Method> aopMethods) {
        super(327680, cv);
        this.orginClz = clz;
        this.aopMethods = aopMethods;
        this.clzName = newClzName;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, this.clzName.replace('.', '/'), signature, name, interfaces);
        MethodVisitor mv = super.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, name, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            return null;
        }
        int badModifiers = 1050;
        if ((access & badModifiers) != 0) {
            return null;
        }
        if (this.aopMethods.containsKey(name)) {
            Method method = this.aopMethods.get(name);
            Box dbBiz = method.getAnnotation(Box.class);
            if (dbBiz == null) {
                return null;
            }
            String methodDesc = Type.getMethodDescriptor((Method)method);
            if (!desc.equals(methodDesc)) {
                return null;
            }
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, null);
            AsmMethod asmMethod = new AsmMethod(access, name, desc, signature, exceptions, method, this.clzName, this.orginClz);
            ProxyMethodWritor.write(mv, asmMethod);
            return null;
        }
        return null;
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }
}

