/*
 * Decompiled with CFR 0.152.
 */
package org.yx.asm;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.yx.asm.AsmMethod;
import org.yx.asm.AsmUtils;
import org.yx.bean.Box;
import org.yx.conf.AppInfo;

public class ProxyMethodWritor {
    private static int SINGLE = AppInfo.getInt("sumk.aop.single", 1);
    private static int WIDTH = AppInfo.getInt("sumk.aop.width", 2);
    private static final String AOPEXCUTOR = "org/yx/common/AopExcutor";

    private static int load(MethodVisitor mv, Object type, int frameIndex) {
        if (Opcodes.INTEGER.equals(type)) {
            mv.visitVarInsn(21, frameIndex);
            return frameIndex + SINGLE;
        }
        if (Opcodes.LONG.equals(type)) {
            mv.visitVarInsn(22, frameIndex);
            return frameIndex + WIDTH;
        }
        if (Opcodes.FLOAT.equals(type)) {
            mv.visitVarInsn(23, frameIndex);
            return frameIndex + SINGLE;
        }
        if (Opcodes.DOUBLE.equals(type)) {
            mv.visitVarInsn(24, frameIndex);
            return frameIndex + WIDTH;
        }
        mv.visitVarInsn(25, frameIndex);
        return frameIndex + SINGLE;
    }

    private static void store(MethodVisitor mv, Object type, int frameIndex) {
        if (Opcodes.INTEGER.equals(type)) {
            mv.visitVarInsn(54, frameIndex);
        } else if (Opcodes.LONG.equals(type)) {
            mv.visitVarInsn(55, frameIndex);
        } else if (Opcodes.FLOAT.equals(type)) {
            mv.visitVarInsn(56, frameIndex);
        } else if (Opcodes.DOUBLE.equals(type)) {
            mv.visitVarInsn(57, frameIndex);
        } else {
            mv.visitVarInsn(58, frameIndex);
        }
    }

    private static void jReturn(MethodVisitor mv, Object type) {
        if (Opcodes.INTEGER.equals(type)) {
            mv.visitInsn(172);
        } else if (Opcodes.LONG.equals(type)) {
            mv.visitInsn(173);
        } else if (Opcodes.FLOAT.equals(type)) {
            mv.visitInsn(174);
        } else if (Opcodes.DOUBLE.equals(type)) {
            mv.visitInsn(175);
        } else {
            mv.visitInsn(176);
        }
    }

    private static void loadArgs(MethodVisitor mv, List<Object> argTypes, int frameIndex) {
        ++frameIndex;
        for (Object argType : argTypes) {
            frameIndex = ProxyMethodWritor.load(mv, argType, frameIndex);
        }
    }

    private static int argLength(List<Object> argTypes) {
        int size = 0;
        for (Object type : argTypes) {
            if (Opcodes.LONG.equals(type) || Opcodes.DOUBLE.equals(type)) {
                size += WIDTH;
                continue;
            }
            size += SINGLE;
        }
        return size;
    }

    public static void write(MethodVisitor mv, AsmMethod asmMethod) {
        if (asmMethod.desc.endsWith(")V")) {
            ProxyMethodWritor.writeVoid(mv, asmMethod);
        } else {
            ProxyMethodWritor.writeWithReturn(mv, asmMethod);
        }
    }

    public static void writeVoid(MethodVisitor mv, AsmMethod asmMethod) {
        Box db = asmMethod.method.getAnnotation(Box.class);
        if (db == null) {
            return;
        }
        String superowener = Type.getInternalName(asmMethod.superClz);
        String currentClz = asmMethod.currentClz.replace('.', '/');
        List<Object> argTypes = AsmUtils.getImplicitFrame(asmMethod.desc.substring(asmMethod.desc.indexOf("(") + 1, asmMethod.desc.indexOf(")")));
        int localVariableIndex = ProxyMethodWritor.argLength(argTypes);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Exception");
        Label l3 = new Label();
        Label l4 = new Label();
        mv.visitTryCatchBlock(l0, l3, l4, null);
        mv.visitTypeInsn(187, AOPEXCUTOR);
        mv.visitInsn(89);
        mv.visitInsn(db.embed() ? 4 : 3);
        mv.visitMethodInsn(183, AOPEXCUTOR, "<init>", "(Z)V", false);
        mv.visitVarInsn(58, localVariableIndex + 1);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitLdcInsn((Object)db.dbName());
        mv.visitFieldInsn(178, "org/yx/db/DBType", db.dbType().toString(), "Lorg/yx/db/DBType;");
        mv.visitMethodInsn(182, AOPEXCUTOR, "begin", "(Ljava/lang/String;Lorg/yx/db/DBType;)V", false);
        mv.visitVarInsn(25, 0);
        ProxyMethodWritor.loadArgs(mv, argTypes, 0);
        mv.visitMethodInsn(183, superowener, asmMethod.name, asmMethod.desc, false);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitMethodInsn(182, AOPEXCUTOR, "commit", "()V", false);
        mv.visitLabel(l1);
        Label l5 = new Label();
        mv.visitJumpInsn(167, l5);
        mv.visitLabel(l2);
        ArrayList<Object> list = new ArrayList<Object>(8);
        list.add(currentClz);
        list.addAll(argTypes);
        list.add(AOPEXCUTOR);
        Object[] frames = list.toArray(new Object[list.size()]);
        mv.visitFrame(0, frames.length, frames, 1, new Object[]{"java/lang/Exception"});
        mv.visitVarInsn(58, localVariableIndex + 2);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitVarInsn(25, localVariableIndex + 2);
        mv.visitMethodInsn(182, AOPEXCUTOR, "rollback", "(Ljava/lang/Throwable;)V", false);
        mv.visitLabel(l3);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitMethodInsn(182, AOPEXCUTOR, "close", "()V", false);
        Label l6 = new Label();
        mv.visitJumpInsn(167, l6);
        mv.visitLabel(l4);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        mv.visitVarInsn(58, localVariableIndex + 3);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitMethodInsn(182, AOPEXCUTOR, "close", "()V", false);
        mv.visitVarInsn(25, localVariableIndex + 3);
        mv.visitInsn(191);
        mv.visitLabel(l5);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitMethodInsn(182, AOPEXCUTOR, "close", "()V", false);
        mv.visitLabel(l6);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        mv.visitMaxs(Math.max(3, localVariableIndex + 1), 4 + localVariableIndex);
        mv.visitEnd();
    }

    public static void writeWithReturn(MethodVisitor mv, AsmMethod asmMethod) {
        Box db = asmMethod.method.getAnnotation(Box.class);
        if (db == null) {
            return;
        }
        String superowener = Type.getInternalName(asmMethod.superClz);
        String currentClz = asmMethod.currentClz.replace('.', '/');
        List<Object> argTypes = AsmUtils.getImplicitFrame(asmMethod.desc.substring(asmMethod.desc.indexOf("(") + 1, asmMethod.desc.indexOf(")")));
        Object returnType = AsmUtils.getImplicitFrame(asmMethod.desc.substring(asmMethod.desc.indexOf(")") + 1)).get(0);
        int localVariableIndex = ProxyMethodWritor.argLength(argTypes);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Exception");
        Label l3 = new Label();
        mv.visitTryCatchBlock(l0, l1, l3, null);
        Label l4 = new Label();
        mv.visitTryCatchBlock(l2, l4, l3, null);
        mv.visitTypeInsn(187, AOPEXCUTOR);
        mv.visitInsn(89);
        mv.visitInsn(db.embed() ? 4 : 3);
        mv.visitMethodInsn(183, AOPEXCUTOR, "<init>", "(Z)V", false);
        mv.visitVarInsn(58, localVariableIndex + 1);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitLdcInsn((Object)db.dbName());
        mv.visitFieldInsn(178, "org/yx/db/DBType", db.dbType().toString(), "Lorg/yx/db/DBType;");
        mv.visitMethodInsn(182, AOPEXCUTOR, "begin", "(Ljava/lang/String;Lorg/yx/db/DBType;)V", false);
        mv.visitVarInsn(25, 0);
        ProxyMethodWritor.loadArgs(mv, argTypes, 0);
        mv.visitMethodInsn(183, superowener, asmMethod.name, asmMethod.desc, false);
        int methodReturnFrameIndex = localVariableIndex + 2;
        ProxyMethodWritor.store(mv, returnType, methodReturnFrameIndex);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitMethodInsn(182, AOPEXCUTOR, "commit", "()V", false);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitMethodInsn(182, AOPEXCUTOR, "close", "()V", false);
        ProxyMethodWritor.load(mv, returnType, methodReturnFrameIndex);
        ProxyMethodWritor.jReturn(mv, returnType);
        mv.visitLabel(l2);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(currentClz);
        list.addAll(argTypes);
        list.add(AOPEXCUTOR);
        Object[] frames = list.toArray(new Object[list.size()]);
        mv.visitFrame(0, frames.length, frames, 1, new Object[]{"java/lang/Exception"});
        mv.visitVarInsn(58, localVariableIndex + 2);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitVarInsn(25, localVariableIndex + 2);
        mv.visitMethodInsn(182, AOPEXCUTOR, "rollback", "(Ljava/lang/Throwable;)V", false);
        mv.visitLabel(l4);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitMethodInsn(182, AOPEXCUTOR, "close", "()V", false);
        Label l5 = new Label();
        mv.visitJumpInsn(167, l5);
        mv.visitLabel(l3);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        mv.visitVarInsn(58, localVariableIndex + 3);
        mv.visitVarInsn(25, localVariableIndex + 1);
        mv.visitMethodInsn(182, AOPEXCUTOR, "close", "()V", false);
        mv.visitVarInsn(25, localVariableIndex + 3);
        mv.visitInsn(191);
        mv.visitLabel(l5);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitTypeInsn(187, "org/yx/exception/SumkException");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)new Integer(-364533425));
        mv.visitLdcInsn((Object)"you are locky to see me^_^");
        mv.visitMethodInsn(183, "org/yx/exception/SumkException", "<init>", "(ILjava/lang/String;)V", false);
        mv.visitInsn(191);
        mv.visitMaxs(Math.max(4, localVariableIndex + 1), 4 + localVariableIndex);
        mv.visitEnd();
    }
}

