/*
 * Decompiled with CFR 0.152.
 */
package org.yx.bean;

import java.util.ArrayList;
import java.util.List;
import org.yx.bean.BeanEvent;
import org.yx.listener.Listener;
import org.yx.listener.SumkEvent;
import org.yx.log.Log;
import org.yx.util.StringUtils;

public abstract class AbstractBeanListener
implements Listener<BeanEvent> {
    protected List<String> packages = new ArrayList<String>(128);
    protected boolean valid = false;

    public AbstractBeanListener(String packs) {
        String[] ps;
        if (StringUtils.isEmpty(packs)) {
            return;
        }
        for (String p : ps = packs.split(",")) {
            this.addPackage(p);
        }
        this.valid = this.packages.size() > 0;
    }

    public boolean addPackage(String p) {
        if ((p = p.trim()).isEmpty()) {
            return false;
        }
        List<String> ps = this.packages;
        String p2 = p + ".";
        if (!(ps = new ArrayList<String>(ps)).contains(p2)) {
            ps.add(p2);
            this.packages = ps;
            Log.get(this.getClass()).trace("add package {}", (Object)p);
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(SumkEvent event) {
        if (!this.valid) {
            return false;
        }
        if (!BeanEvent.class.isInstance(event)) {
            return false;
        }
        String clzName = ((BeanEvent)event).clz().getName();
        if (clzName.startsWith("org.yx.")) {
            return true;
        }
        List<String> packs = this.packages;
        for (String pack : packs) {
            if (!clzName.startsWith(pack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getTags() {
        return null;
    }
}

