/*
 * Decompiled with CFR 0.152.
 */
package org.yx.bean;

import org.yx.bean.AbstractBeanListener;
import org.yx.bean.Bean;
import org.yx.bean.BeanEvent;
import org.yx.bean.BeanPool;
import org.yx.bean.InnerIOC;
import org.yx.conf.AppInfo;
import org.yx.db.Cachable;
import org.yx.db.Cached;
import org.yx.exception.SumkException;

public class BeanFactory
extends AbstractBeanListener {
    public BeanFactory() {
        super(AppInfo.get("sumk.ioc"));
    }

    @Override
    public void listen(BeanEvent event) {
        try {
            Class<?> clz = event.clz();
            Bean b = clz.getAnnotation(Bean.class);
            if (b != null) {
                InnerIOC.putClass(b.value(), clz);
            }
            if (AppInfo.getBoolean("sumk.ioc.cached.disable", false)) {
                return;
            }
            Cached c = clz.getAnnotation(Cached.class);
            if (c != null) {
                Object bean = InnerIOC.putClass("cache." + BeanPool.getBeanName(clz), clz);
                if (!Cachable.class.isInstance(bean)) {
                    SumkException.throwException(35423543, clz.getName() + " is not instance of Cachable");
                }
                if ("cache".equals(AppInfo.get("sumk.dao.cache", "cache"))) {
                    Cachable cache = (Cachable)bean;
                    cache.setCacheEnable(true);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            SumkException.throwException(-345365, "IOC error", e);
        }
    }
}

