/*
 * Decompiled with CFR 0.152.
 */
package org.yx.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.yx.asm.ProxyClassFactory;
import org.yx.bean.BeanWrapper;
import org.yx.common.Ordered;
import org.yx.exception.TooManyBeanException;
import org.yx.log.Log;
import org.yx.util.Assert;
import org.yx.util.StringUtils;

public class BeanPool {
    private final Map<String, Object> map = new ConcurrentHashMap<String, Object>(128, 0.5f);

    public static String getBeanName(Class<?> clz) {
        String name = StringUtils.uncapitalize(clz.getSimpleName());
        if (name.endsWith("Impl")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    static Set<String> getBeanNames(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        HashSet interfaces = new HashSet();
        BeanPool.resloveSuperClassAndInterface(clazz, interfaces);
        HashSet<String> names = new HashSet<String>();
        interfaces.forEach(clz -> names.add(BeanPool.getBeanName(clz)));
        return names;
    }

    private static void resloveSuperClassAndInterface(Class<?> clazz, Set<Class<?>> interfaces) {
        while (clazz != null && !clazz.getName().startsWith("java.") && (clazz.getModifiers() & 1) != 0) {
            interfaces.add(clazz);
            Class<?>[] ifcs = clazz.getInterfaces();
            if (ifcs != null) {
                for (Class<?> ifc : ifcs) {
                    BeanPool.resloveSuperClassAndInterface(ifc, interfaces);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private final Object getBean(Object v) {
        BeanWrapper w = (BeanWrapper)v;
        return w.getBean();
    }

    private final Class<?> getBeanClass(Object v) {
        BeanWrapper w = (BeanWrapper)v;
        return w.getTargetClass();
    }

    Map<Object, BeanWrapper> allBeans() {
        HashMap<Object, BeanWrapper> beans = new HashMap<Object, BeanWrapper>();
        Collection<Object> vs = this.map.values();
        for (Object v : vs) {
            Object[] objs;
            if (!v.getClass().isArray()) {
                Object bean = this.getBean(v);
                if (beans.containsKey(bean)) continue;
                beans.put(bean, (BeanWrapper)v);
                continue;
            }
            for (Object o : objs = (Object[])v) {
                Object bean = this.getBean(o);
                if (beans.containsKey(bean)) continue;
                beans.put(bean, (BeanWrapper)o);
            }
        }
        return beans;
    }

    public <T> T putClass(String beanName, Class<T> clz) throws Exception {
        Set<String> names;
        Assert.notNull(clz);
        Set<String> set = names = beanName == null || (beanName = beanName.trim()).isEmpty() ? BeanPool.getBeanNames(clz) : Collections.singleton(beanName);
        if (names == null || names.isEmpty()) {
            names = Collections.singleton(BeanPool.getBeanName(clz));
        }
        Class<?> proxyClz = ProxyClassFactory.proxyIfNeed(clz);
        Object bean = proxyClz.newInstance();
        BeanWrapper w = new BeanWrapper(bean, clz);
        for (String name : names) {
            this.put(name, w);
        }
        return this.getBean(beanName, clz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String name, BeanWrapper w) {
        Class<?> clz = w.getTargetClass();
        Object oldWrapper = this.map.putIfAbsent(name, w);
        if (oldWrapper == null) {
            return;
        }
        BeanPool beanPool = this;
        synchronized (beanPool) {
            BeanWrapper[] objs;
            if (!oldWrapper.getClass().isArray()) {
                if (clz == this.getBeanClass(oldWrapper)) {
                    Log.get(this.getClass(), "put").info("{}={} duplicate,will be ignored", (Object)name, (Object)clz.getName());
                    return;
                }
                this.map.put(name, new BeanWrapper[]{(BeanWrapper)oldWrapper, w});
                return;
            }
            for (BeanWrapper o : objs = (BeanWrapper[])oldWrapper) {
                if (clz != this.getBeanClass(o)) continue;
                Log.get(this.getClass(), "put").info("{}={} duplicate,will be ignored.", (Object)name, (Object)clz.getName());
                return;
            }
            BeanWrapper[] beans = new BeanWrapper[objs.length + 1];
            System.arraycopy(objs, 0, beans, 0, objs.length);
            beans[beans.length - 1] = w;
            this.map.put(name, beans);
        }
    }

    public <T> T getBean(String name, Class<T> clz) {
        BeanWrapper[] objs;
        Object bw;
        if (name == null || name.length() == 0) {
            name = BeanPool.getBeanName(clz);
        }
        if (clz == Object.class) {
            clz = null;
        }
        if ((bw = this.map.get(name)) == null) {
            return null;
        }
        if (!bw.getClass().isArray()) {
            Object obj = this.getBean(bw);
            if (clz == null || clz.isInstance(obj)) {
                return (T)obj;
            }
            throw new ClassCastException(name + " type error\u3002real is " + obj.getClass().getName() + ",cannot  compatible with " + clz.getName());
        }
        if (clz == null) {
            throw new TooManyBeanException(name + " exist multi instance");
        }
        for (BeanWrapper o : objs = (BeanWrapper[])bw) {
            if (clz != o.getBean().getClass()) continue;
            return (T)o.getBean();
        }
        Object bean = null;
        for (BeanWrapper w : objs) {
            Object o = w.getBean();
            if (!clz.isInstance(o)) continue;
            if (bean != null) {
                Log.get(this.getClass(), "getBean").error(name + "\u5b58\u5728\u591a\u4e2a\u5b9e\u4f8b:" + o.getClass().getName() + "," + bean.getClass().getName());
                throw new TooManyBeanException(name + "\u5b58\u5728\u591a\u4e2a" + clz.getName() + "\u5b9e\u4f8b");
            }
            bean = o;
        }
        return (T)bean;
    }

    public <T> List<T> getBeans(String name, Class<T> clz) {
        BeanWrapper[] objs;
        Object bw;
        ArrayList<Object> list = new ArrayList<Object>(4);
        if (name == null || name.length() == 0) {
            name = BeanPool.getBeanName(clz);
        }
        if (clz == Object.class) {
            clz = null;
        }
        if ((bw = this.map.get(name)) == null) {
            return list;
        }
        if (!bw.getClass().isArray()) {
            Object obj = this.getBean(bw);
            if (clz == null || clz.isInstance(obj)) {
                list.add(obj);
            }
            return list;
        }
        for (BeanWrapper w : objs = (BeanWrapper[])bw) {
            Object o = w.getBean();
            if (!clz.isInstance(o)) continue;
            list.add(o);
        }
        if (Ordered.class.isAssignableFrom(clz)) {
            list.sort(null);
        }
        return list;
    }

    public String toString() {
        Iterator<Map.Entry<String, Object>> i = this.map.entrySet().iterator();
        if (!i.hasNext()) {
            return "empty bean";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            Map.Entry<String, Object> e = i.next();
            String key = e.getKey();
            Object value = e.getValue();
            sb.append(key);
            sb.append(':');
            if (value.getClass().isArray()) {
                sb.append("[");
                Object[] objs = (Object[])value;
                for (int k = 0; k < objs.length; ++k) {
                    if (k > 0) {
                        sb.append(",");
                    }
                    Object o = objs[k];
                    sb.append(this.getBeanClass(o).getName());
                }
                sb.append("]");
            } else {
                sb.append(this.getBeanClass(value).getName());
            }
            if (!i.hasNext()) {
                return sb.toString();
            }
            sb.append(',').append(' ');
        }
    }
}

