/*
 * Decompiled with CFR 0.152.
 */
package org.yx.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yx.asm.AsmUtils;
import org.yx.bean.BeanEvent;
import org.yx.bean.BeanPool;
import org.yx.bean.BeanWrapper;
import org.yx.bean.IOC;
import org.yx.bean.Inject;
import org.yx.bean.InjectParser;
import org.yx.bean.InnerIOC;
import org.yx.bean.Loader;
import org.yx.bean.watcher.BeanWatcher;
import org.yx.bean.watcher.IntfImplement;
import org.yx.bean.watcher.LifeCycleHandler;
import org.yx.bean.watcher.Scaned;
import org.yx.common.ClassScaner;
import org.yx.conf.AppInfo;
import org.yx.db.Cached;
import org.yx.exception.SumkException;
import org.yx.listener.Listener;
import org.yx.listener.ListenerGroup;
import org.yx.listener.ListenerGroupImpl;
import org.yx.log.Log;
import org.yx.util.CollectionUtils;

public final class BeanPublisher {
    private static ListenerGroup<BeanEvent> group = new ListenerGroupImpl<BeanEvent>();

    public static synchronized void publishBeans(List<String> packageNames) {
        if (packageNames == null || packageNames.isEmpty()) {
            Log.get("sumk.SYS").info("sumk.ioc in app.properties cannot be empty");
            return;
        }
        if (!packageNames.contains("org.yx")) {
            packageNames.add(0, "org.yx");
        }
        IntfImplement.beforeScan();
        ClassScaner scaner = new ClassScaner();
        Collection<String> clzs = scaner.parse(packageNames.toArray(new String[packageNames.size()]));
        Collection<String> userBeans = BeanPublisher.fileConfigBeans();
        if (userBeans != null && userBeans.size() > 0) {
            clzs.addAll(userBeans);
        }
        for (String c : clzs) {
            try {
                Class<?> clz = BeanPublisher.class.getClassLoader().loadClass(c);
                if (AsmUtils.notPublicOnly(clz.getModifiers()) || clz.isInterface() || clz.isAnonymousClass() || clz.isLocalClass() || clz.isAnnotation() || clz.isEnum()) continue;
                BeanPublisher.publish(new BeanEvent(clz));
            }
            catch (Exception e) {
                Log.printStack(e);
            }
            catch (NoClassDefFoundError e) {
                if (!c.startsWith("org.yx.")) {
                    throw e;
                }
                Log.get("sumk.SYS").debug("{} ignored.{}", (Object)c, (Object)e.getMessage());
            }
        }
        if (AppInfo.getBoolean("sumk.ioc.showinfo", false)) {
            Log.get("sumk.SYS").debug(IOC.info());
        }
        BeanPublisher.autoWiredAll();
    }

    private static Collection<String> fileConfigBeans() {
        try {
            Enumeration<URL> urls = Loader.getResources("beans.sumk");
            if (urls == null) {
                return null;
            }
            HashSet<String> userBeans = new HashSet<String>();
            while (urls.hasMoreElements()) {
                List<String> list = CollectionUtils.loadList(urls.nextElement().openStream());
                if (list == null || list.isEmpty()) continue;
                userBeans.addAll(list);
            }
            return userBeans;
        }
        catch (Exception e) {
            Log.printStack(e);
            return null;
        }
    }

    private static Object getBean(Field f, Class<?> clz) {
        Object target;
        String name = f.getName();
        if (clz == Object.class) {
            clz = f.getType();
        }
        if ((target = IOC.get(name, clz)) != null) {
            return target;
        }
        target = IOC.get(name, f.getType());
        if (target != null) {
            return target;
        }
        return IOC.get(clz);
    }

    private static Object getCacheObject(Field f) {
        String name = f.getName();
        Class<?> clz = f.getType();
        Object target = IOC.cache(name, f.getType());
        if (target != null) {
            return target;
        }
        return IOC.cache(null, clz);
    }

    private static void injectField(Field f, Object bean, Object target) {
        boolean access = f.isAccessible();
        if (!access) {
            f.setAccessible(true);
        }
        try {
            f.set(bean, target);
        }
        catch (Exception e) {
            Log.printStack(e);
        }
    }

    private static void autoWiredAll() {
        BeanPool pool = InnerIOC.pool;
        Map<Object, BeanWrapper> beanMap = pool.allBeans();
        Collection<BeanWrapper> beanwrapers = beanMap.values();
        Set<Object> beans = beanMap.keySet();
        IOC.getBeans(Scaned.class).forEach(w -> w.afterScaned());
        BeanPublisher.injectProperties(beans);
        IOC.getBeans(BeanWatcher.class).forEach(watcher -> {
            for (BeanWrapper bw : beanwrapers) {
                if (BeanWatcher.class.isAssignableFrom(bw.getTargetClass()) || !watcher.acceptClass().isInstance(bw.getBean())) continue;
                watcher.beanPost(bw);
            }
        });
        LifeCycleHandler.instance.start();
    }

    private static void injectProperties(Collection<Object> beans) {
        beans.forEach(bean -> {
            for (Class<?> tempClz = bean.getClass(); tempClz != null && !tempClz.getName().startsWith("java."); tempClz = tempClz.getSuperclass()) {
                Field[] fs;
                for (Field f : fs = tempClz.getDeclaredFields()) {
                    List<?> target;
                    Inject inject = f.getAnnotation(Inject.class);
                    if (inject != null) {
                        Class<?> clz = inject.beanClz();
                        target = null;
                        if (inject.handler().length() > 0) {
                            try {
                                target = InjectParser.get(f, inject, bean);
                            }
                            catch (Exception e) {
                                Log.printStack(e);
                                SumkException.throwException(-235435628, bean.getClass().getName() + "." + f.getName() + " cannot injected with " + inject.handler());
                            }
                        } else {
                            target = f.getType().isArray() ? BeanPublisher.getArrayField(f, clz, bean) : (List.class == f.getType() ? BeanPublisher.getListField(f, clz, bean) : (Set.class == f.getType() ? BeanPublisher.getSetField(f, clz, bean) : BeanPublisher.getBean(f, clz)));
                        }
                        if (target == null) {
                            SumkException.throwException(-235435658, bean.getClass().getName() + "." + f.getName() + " cannot injected.");
                        }
                        BeanPublisher.injectField(f, bean, target);
                        continue;
                    }
                    Cached c = f.getAnnotation(Cached.class);
                    if (c == null) continue;
                    target = BeanPublisher.getCacheObject(f);
                    if (target == null) {
                        SumkException.throwException(23526568, bean.getClass().getName() + "." + f.getName() + " cannot injected");
                    }
                    BeanPublisher.injectField(f, bean, target);
                }
            }
        });
    }

    private static Set<?> getSetField(Field f, Class<?> clz, Object bean) {
        List<?> target;
        if (clz == Object.class) {
            SumkException.throwException(-23984568, "" + bean.getClass().getName() + "." + f.getName() + ": beanClz of @Inject in list type cannot be null");
        }
        if ((target = IOC.getBeans(clz)) == null || target.isEmpty()) {
            return null;
        }
        return new HashSet(target);
    }

    private static List<?> getListField(Field f, Class<?> clz, Object bean) {
        List<?> target;
        if (clz == Object.class) {
            SumkException.throwException(-23984568, "" + bean.getClass().getName() + "." + f.getName() + ": beanClz of @Inject in list type cannot be null");
        }
        if ((target = IOC.getBeans(clz)) == null || target.isEmpty()) {
            return null;
        }
        return target;
    }

    private static Object getArrayField(Field f, Class<?> clz, Object bean) {
        Class<?> filedType = f.getType().getComponentType();
        if (clz == Object.class) {
            clz = filedType;
        } else if (!filedType.isAssignableFrom(clz)) {
            SumkException.throwException(-239864568, bean.getClass().getName() + "." + f.getName() + " is " + filedType.getSimpleName() + "[], is not " + clz.getSimpleName() + "[]");
        }
        List<?> target = IOC.getBeans(clz);
        if (target == null || target.isEmpty()) {
            return null;
        }
        return target.toArray((Object[])Array.newInstance(filedType, target.size()));
    }

    public static void publish(BeanEvent event) {
        group.listen(event);
    }

    public static synchronized boolean addListener(Listener<BeanEvent> listener) {
        group.addListener(listener);
        return true;
    }

    public static synchronized boolean addListeners(List<Listener> list) {
        for (Listener l : list) {
            BeanPublisher.addListener(l);
        }
        return true;
    }

    public static synchronized void removeListener(Listener<BeanEvent> listener) {
        group.removeListener(listener);
    }
}

