/*
 * Decompiled with CFR 0.152.
 */
package org.yx.bean.watcher;

import java.lang.reflect.Constructor;
import org.yx.bean.Bean;
import org.yx.bean.IOC;
import org.yx.bean.Plugin;
import org.yx.common.StartContext;
import org.yx.conf.AppInfo;
import org.yx.http.IntfHandlerFactorysBean;
import org.yx.http.UploadHandlerFactorysBean;
import org.yx.http.handler.HttpHandlerChain;
import org.yx.log.Log;
import org.yx.main.SumkServer;

@Bean
public class HttpServer
implements Plugin {
    private Plugin server;

    @Override
    public void start() {
        if (!SumkServer.isHttpEnable()) {
            return;
        }
        try {
            int port;
            HttpHandlerChain.inst.setHandlers(IOC.get(IntfHandlerFactorysBean.class).create());
            if (AppInfo.getBoolean("http.upload", true)) {
                HttpHandlerChain.upload.setHandlers(IOC.get(UploadHandlerFactorysBean.class).create());
            }
            if ((port = AppInfo.getInt("http.port", -1)) < 1) {
                return;
            }
            String nojetty = "sumk.http.nojetty";
            if (StartContext.inst.get(nojetty) != null || AppInfo.getBoolean(nojetty, false)) {
                return;
            }
            String hs = AppInfo.get("http.starter.class", "org.yx.http.start.JettyServer");
            if (!hs.contains(".")) {
                return;
            }
            Class<?> httpClz = Class.forName(hs);
            Constructor<?> c = httpClz.getConstructor(Integer.TYPE);
            this.server = (Plugin)c.newInstance(port);
            this.server.start();
        }
        catch (Exception e) {
            Log.printStack(e);
            System.exit(-1);
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Override
    public int order() {
        return 10000;
    }
}

