/*
 * Decompiled with CFR 0.152.
 */
package org.yx.bean.watcher;

import java.io.InputStream;
import java.util.List;
import org.yx.bean.IOC;
import org.yx.bean.Loader;
import org.yx.bean.Plugin;
import org.yx.log.Log;
import org.yx.main.SumkServer;
import org.yx.util.CollectionUtils;
import org.yx.util.StringUtils;

public class LifeCycleHandler {
    public static final LifeCycleHandler instance = new LifeCycleHandler();

    private void runFromFile() {
        try {
            InputStream in = Loader.getResourceAsStream("sumk-exec");
            if (in == null) {
                return;
            }
            List<String> list = CollectionUtils.loadList(in);
            for (String key : list) {
                if (StringUtils.isEmpty(key)) continue;
                Class<?> clz = Loader.loadClass(key);
                if (!Runnable.class.isAssignableFrom(clz)) {
                    Log.get("sumk.SYS").info("{} should implements Runnable", (Object)clz.getSimpleName());
                    continue;
                }
                Runnable r = (Runnable)clz.newInstance();
                r.run();
            }
        }
        catch (Exception e) {
            Log.printStack(e);
            System.exit(-1);
        }
    }

    public void start() {
        this.startBeans();
        this.runFromFile();
        Runtime.getRuntime().addShutdownHook(new Thread(SumkServer::stop));
    }

    private void startBeans() {
        List<Plugin> lifes = IOC.getBeans(Plugin.class);
        if (lifes == null || lifes.isEmpty()) {
            return;
        }
        lifes.forEach(Plugin::start);
    }
}

