/*
 * Decompiled with CFR 0.152.
 */
package org.yx.common;

import java.sql.SQLException;
import org.yx.db.DBType;
import org.yx.db.conn.ConnectionPool;
import org.yx.exception.BizException;
import org.yx.exception.SumkException;
import org.yx.log.Log;

public class AopExcutor {
    private ConnectionPool dbCtx = null;
    private boolean embed;

    public AopExcutor(boolean embed) {
        this.embed = embed;
    }

    public void begin(String dbName, DBType dbType) {
        Log.get(AopExcutor.class).trace("begin with embed:{}", (Object)this.embed);
        this.dbCtx = this.embed ? ConnectionPool.createIfAbsent(dbName, dbType) : ConnectionPool.create(dbName, dbType);
    }

    public void rollback(Throwable e) {
        if (BizException.class.isInstance(e)) {
            Log.get("sumk.SYS").info("code:{},message:{}", (Object)((BizException)BizException.class.cast(e)).getCode(), (Object)e.getMessage());
        } else {
            Log.printStack(e);
        }
        if (this.dbCtx != null) {
            try {
                this.dbCtx.rollback();
            }
            catch (SQLException e1) {
                Log.printStack(e1);
            }
        }
        if (RuntimeException.class.isInstance(e)) {
            throw (RuntimeException)e;
        }
        throw new SumkException(1076971, "\u4e1a\u52a1\u6267\u884c\u51fa\u9519", e);
    }

    public void commit() {
        if (this.dbCtx == null) {
            return;
        }
        try {
            this.dbCtx.commit();
        }
        catch (SQLException e) {
            Log.printStack(e);
        }
    }

    public void close() {
        if (this.dbCtx == null) {
            return;
        }
        try {
            this.dbCtx.close();
        }
        catch (Exception e) {
            SumkException.throwException(7820198, "error in commit," + e.getMessage(), e);
        }
    }
}

