/*
 * Decompiled with CFR 0.152.
 */
package org.yx.common;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.yx.log.Log;

public class ClassScaner {
    public Collection<String> parse(String ... packageNames) {
        HashSet<String> classNameList = new HashSet<String>(240);
        if (packageNames == null) {
            return classNameList;
        }
        ClassLoader classLoader = ClassScaner.class.getClassLoader();
        for (String packageName : packageNames) {
            String packagePath = packageName.replace('.', '/');
            try {
                Enumeration<URL> eUrl = classLoader.getResources(packagePath);
                while (eUrl.hasMoreElements()) {
                    URL url = eUrl.nextElement();
                    String filePath = url.getFile();
                    if (filePath.indexOf("src/test/") != -1 || filePath.indexOf("src/main/") != -1) continue;
                    File file = new File(url.getPath());
                    this.parseFile(classNameList, file, packagePath, url);
                }
            }
            catch (IOException ex) {
                Log.get("ClassScaner").error("parse " + packageName + "failed", (Throwable)ex);
            }
        }
        return classNameList;
    }

    private void parseFile(Collection<String> classNameList, File file, String packagePath, URL url) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (subFiles == null) {
                return;
            }
            for (File subFile : subFiles) {
                this.parseFile(classNameList, subFile, packagePath, url);
            }
        } else if (file.getPath().contains(".class")) {
            this.findClass(classNameList, file, packagePath);
        } else if (file.getPath().contains(".jar")) {
            this.findClassInJar(classNameList, url, packagePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findClassInJar(Collection<String> classNameList, URL url, String packagePath) {
        JarFile jarFile = null;
        try {
            jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> jarEntryEnum = jarFile.entries();
            String packageName = packagePath.replaceAll("/", ".");
            while (jarEntryEnum.hasMoreElements()) {
                String className;
                JarEntry jarEntry = jarEntryEnum.nextElement();
                if (!jarEntry.getName().endsWith(".class") || !(className = jarEntry.getName().replaceAll("/", ".").substring(0, jarEntry.getName().length() - 6)).startsWith(packageName) || classNameList.contains(className)) continue;
                classNameList.add(className);
            }
        }
        catch (IOException ex) {
            Log.get("ClassScaner").error("findClassInJar can not found jar or class", (Throwable)ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    Log.get("ClassScaner").error("can not close jarFile in findClassInJar", (Throwable)ex);
                }
            }
        }
    }

    private void findClass(Collection<String> classNameList, File file, String packagePath) {
        String packageName;
        String absolutePath = file.getAbsolutePath().replaceAll("\\\\", "/");
        int index = absolutePath.indexOf(packagePath);
        String className = absolutePath.substring(index);
        className = className.replace('/', '.');
        if ((className = className.substring(0, className.length() - 6)).startsWith(packageName = packagePath.replace('/', '.')) && !classNameList.contains(className)) {
            classNameList.add(className);
        }
    }
}

