/*
 * Decompiled with CFR 0.152.
 */
package org.yx.common;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Date;
import org.yx.util.DateUtils;
import org.yx.util.StringUtils;

public class DateTimeTypeAdapter
extends TypeAdapter<Date> {
    private String dateFormat;

    public void setDateFormat(String format) {
        if (StringUtils.isEmpty(format)) {
            this.dateFormat = null;
        }
        this.dateFormat = format;
    }

    public Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.deserializeToDate(in.nextString());
    }

    private Date deserializeToDate(String json) throws IOException {
        if (json == null) {
            return null;
        }
        if (json.contains(":")) {
            String format = null;
            if (this.dateFormat != null && json.length() == this.dateFormat.length()) {
                format = this.dateFormat;
            } else if (json.length() == 19) {
                format = "yyyy-MM-dd HH:mm:ss";
            } else if (json.length() == 23) {
                format = "yyyy-MM-dd HH:mm:ss.SSS";
            }
            if (format != null) {
                try {
                    return DateUtils.parse(json, format);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IOException(json + " cannot convert to Date");
        }
        String num = json;
        if (num.contains(".")) {
            num = num.substring(0, num.indexOf("."));
        }
        return new Date(Long.parseLong(num));
    }

    public void write(JsonWriter out, Date value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (this.dateFormat == null) {
            out.value(value.getTime());
            return;
        }
        out.value(DateUtils.toString(value, this.dateFormat));
    }
}

