/*
 * Decompiled with CFR 0.152.
 */
package org.yx.common;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.yx.common.SeqCounter;
import org.yx.log.Log;

public final class Seq {
    private static final long FROMMILS = 1420041600000L;
    private static final int LOCAL_SEQ_INDEX = 64;
    private AtomicIntegerArray localSeqs = new AtomicIntegerArray(65);
    private SeqCounter counter;

    public Seq() {
        try {
            for (int i = 0; i < this.localSeqs.length(); ++i) {
                this.localSeqs.set(i, ThreadLocalRandom.current().nextInt(256));
            }
        }
        catch (Exception e) {
            Log.printStack(e);
        }
    }

    public void setCounter(SeqCounter counter) {
        this.counter = counter;
    }

    private int localHashIndex(String name) {
        if (name == null || name.isEmpty()) {
            return 64;
        }
        return name.hashCode() & 0x3F;
    }

    private int localSeq(String name) {
        int hash = this.localHashIndex(name);
        int num = this.localSeqs.incrementAndGet(hash);
        if (num > 50000000) {
            this.localSeqs.weakCompareAndSet(hash, num, ThreadLocalRandom.current().nextInt(100));
        }
        return num;
    }

    private static long shortNowMills() {
        return System.currentTimeMillis() - 1420041600000L;
    }

    private static long fullTime(long time) {
        return time + 1420041600000L;
    }

    int sub(String name) {
        if (this.counter != null) {
            try {
                return this.counter.count(name);
            }
            catch (Exception e) {
                Log.printStack(e);
            }
        }
        int sub = ThreadLocalRandom.current().nextInt(256) << 16;
        return (sub |= (int)System.nanoTime() & 0xFF00) | this.localSeq(name) & 0xFF;
    }

    public long next(String name) {
        if (name != null && (name = name.trim()).isEmpty()) {
            name = null;
        }
        long num = Seq.shortNowMills();
        num &= 0x7FFFFFFFFFL;
        int sub = this.sub(name) & 0xFFFFFF;
        return (num <<= 24) | (long)sub;
    }

    public long next() {
        return this.next(null);
    }

    public static long getDate(long seq) {
        long num = seq & 0x7FFFFFFFFF000000L;
        return Seq.fullTime(num >>= 24);
    }
}

