/*
 * Decompiled with CFR 0.152.
 */
package org.yx.common;

import org.yx.util.UUIDSeed;

public class ThreadContext {
    private ActionType type;
    private String act;
    private String sn0;
    public Object info;
    private static ThreadLocal<ThreadContext> holder = new ThreadLocal<ThreadContext>(){

        @Override
        protected ThreadContext initialValue() {
            return new ThreadContext(null, null);
        }
    };

    private ThreadContext(ActionType type, String act) {
        this.type = type;
        this.act = act;
    }

    public ActionType getType() {
        return this.type;
    }

    public String getAct() {
        return this.act;
    }

    public String getSn0() {
        return this.sn0;
    }

    public static ThreadContext httpContext(String act) {
        ThreadContext c = new ThreadContext(ActionType.HTTP, act);
        c.sn0 = (Object)((Object)ActionType.HTTP) + "_" + UUIDSeed.seq();
        holder.set(c);
        return c;
    }

    public static ThreadContext rpcContext(String act, String sn0) {
        ThreadContext c = new ThreadContext(ActionType.RPC, act);
        c.sn0 = sn0;
        holder.set(c);
        return c;
    }

    public static ThreadContext get() {
        return holder.get();
    }

    public static void remove() {
        holder.remove();
    }

    public static enum ActionType {
        HTTP,
        RPC;

    }
}

