/*
 * Decompiled with CFR 0.152.
 */
package org.yx.conf;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import org.yx.conf.NamePairs;
import org.yx.conf.PropertiesInfo;
import org.yx.db.annotation.ColumnType;
import org.yx.log.Log;
import org.yx.rpc.LocalhostUtil;
import org.yx.util.StringUtils;

public class AppInfo {
    public static final String CLASSPATH_ALL_URL_PREFIX = "classpath*:";
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static String appId = "sumk";
    public static int httpSessionTimeout = 3600;
    public static ColumnType modifyByColumnType = ColumnType.ID_DB;
    private static List<Observer> observers = new ArrayList<Observer>(4);
    private static Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    static NamePairs zkInfo = null;
    static final PropertiesInfo info = new PropertiesInfo("app.properties"){

        private Integer intValue(String key) {
            String temp = this.get(key);
            if (temp != null) {
                try {
                    return Integer.valueOf(temp);
                }
                catch (Exception e) {
                    Log.get(AppInfo.class).error(key + "=" + temp + ", is not valid Integer,ignore it");
                }
            }
            return null;
        }

        @Override
        public void deal(InputStream in) throws Exception {
            Integer temp;
            super.deal(in);
            String id = this.get("sumk.appId");
            if (id != null) {
                appId = id;
            }
            if ((temp = this.intValue("http.session.timeout")) != null) {
                httpSessionTimeout = temp;
            }
            observers.forEach(ob -> ob.update(null, null));
        }

        @Override
        public String get(String key) {
            String ret = super.get(key);
            if (ret == null && zkInfo != null) {
                return zkInfo.getValue(key);
            }
            return ret;
        }

        @Override
        public String get(String key, String defaultValue) {
            String value = (String)this.pro.get(key);
            if (value != null && value.length() > 0) {
                return value;
            }
            if (zkInfo != null) {
                value = zkInfo.getValue(key);
            }
            if (value != null && value.length() > 0) {
                return value;
            }
            return defaultValue;
        }
    };

    public static synchronized void addObserver(Observer ob) {
        if (observers.contains(ob)) {
            return;
        }
        observers.add(ob);
        ob.update(null, null);
    }

    public static String getZKUrl() {
        return info.get("sumk.zkurl");
    }

    public static String getIp() {
        String ip = info.get("sumk.ip");
        if (ip != null) {
            return ip;
        }
        try {
            return LocalhostUtil.getLocalIP();
        }
        catch (Exception e) {
            Log.printStack(e);
            return "0.0.0.0";
        }
    }

    public static String getAppId() {
        return appId;
    }

    public static String get(String name) {
        return info.get(name);
    }

    public static String get(String name, String defaultValue) {
        return info.get(name, defaultValue);
    }

    public static int getInt(String name, int defaultValue) {
        String value = info.get(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Charset systemCharset() {
        String charsetName;
        String string = charsetName = info == null ? null : info.get("sumk.charset");
        if (StringUtils.isEmpty(charsetName) || charsetName.equalsIgnoreCase(DEFAULT_CHARSET.name())) {
            return DEFAULT_CHARSET;
        }
        if (!Charset.isSupported(charsetName)) {
            Log.get("sumk.SYS").error("charset '{}' is not supported", (Object)charsetName);
            return DEFAULT_CHARSET;
        }
        return Charset.forName(charsetName);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        String value = info.get(name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return "1".equals(value = value.toLowerCase()) || "true".equals(value);
    }
}

