/*
 * Decompiled with CFR 0.152.
 */
package org.yx.conf;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.yx.db.conn.DataSourceWraper;
import org.yx.log.Log;
import org.yx.util.Assert;
import org.yx.util.SimpleBeanUtil;

public class DBConfig {
    String type = "";
    int weight = 0;
    int read_weight = 0;
    Map<String, String> properties = new HashMap<String, String>();

    public DBConfig() {
        this.properties.put("driverClassName", "com.mysql.jdbc.Driver");
        this.properties.put("validationQuery", "select 1");
        this.properties.put("maxTotal", "30");
        this.properties.put("minIdle", "2");
        this.properties.put("maxIdle", "10");
        this.properties.put("maxWaitMillis", "10000");
        this.properties.put("testOnBorrow", "false");
        this.properties.put("testOnReturn", "false");
        this.properties.put("testWhileIdle", "true");
        this.properties.put("removeAbandonedOnBorrow", "false");
        this.properties.put("removeAbandonedOnMaintenance", "true");
        this.properties.put("removeAbandonedTimeout", "30");
        this.properties.put("logAbandoned", "true");
        this.properties.put("timeBetweenEvictionRunsMillis", "30000");
        this.properties.put("softMinEvictableIdleTimeMillis", "60000");
        this.properties.put("logExpiredConnections", "false");
        this.properties.put("poolPreparedStatements", "false");
        this.properties.put("defaultAutoCommit", "false");
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperties(Map<String, String> p) throws IllegalAccessException, InvocationTargetException {
        Set<String> set = p.keySet();
        block10: for (String key : set) {
            String v = p.get(key);
            if (v == null) {
                Log.get("sumk.db.config").debug("{} key\u7684\u503c\u662fnull\uff0c\u88ab\u5ffd\u7565\u6389", (Object)key);
                continue;
            }
            switch (key) {
                case "type": {
                    this.type = v.toLowerCase();
                    continue block10;
                }
                case "weight": {
                    this.weight = Integer.parseInt(v);
                    continue block10;
                }
                case "read_weight": {
                    this.read_weight = Integer.parseInt(v);
                    continue block10;
                }
            }
            this.properties.put(key, v);
        }
    }

    public DataSourceWraper createDS(String name) throws Exception {
        Assert.isTrue(this.valid(), "url,username,password,type should not be null");
        Assert.isTrue(this.type.matches("^(wr|read|write)$"), "db type should be one of(wr,read,write)");
        DataSourceWraper ds = new DataSourceWraper(name, this.type);
        SimpleBeanUtil.copyProperties((Object)ds, this.properties);
        return ds;
    }

    public boolean valid() {
        return this.type != null && this.properties.get("url") != null && this.properties.get("username") != null && this.properties.get("password") != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getRead_weight() {
        return this.read_weight;
    }

    public void setRead_weight(int read_weight) {
        this.read_weight = read_weight;
    }

    public String toString() {
        return "DBConfig [type=" + this.type + ", weight=" + this.weight + ", read_weight=" + this.read_weight + ", properties=" + this.properties + "]";
    }
}

