/*
 * Decompiled with CFR 0.152.
 */
package org.yx.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.yx.bean.Loader;
import org.yx.conf.AppInfo;
import org.yx.conf.LocalDBResourceFactory;
import org.yx.conf.SingleResourceFactory;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.util.Assert;

public final class DBConfigUtils {
    public static InputStream openConfig(String db) throws Exception {
        String resourceFactory = AppInfo.get("sumk.db.conf.factory." + db, LocalDBResourceFactory.class.getName());
        Class<?> factoryClz = Loader.loadClass(resourceFactory);
        Assert.isTrue(SingleResourceFactory.class.isAssignableFrom(factoryClz), resourceFactory + " should extend from SingleResourceFactory");
        SingleResourceFactory factory = (SingleResourceFactory)factoryClz.newInstance();
        return factory.openInput(db);
    }

    public static Map<String, Map<String, String>> parseIni(String filename) throws FileNotFoundException {
        return DBConfigUtils.parseIni(new FileInputStream(filename));
    }

    public static Map<String, Map<String, String>> parseIni(InputStream in) {
        return new IniFile((InputStream)in).sections;
    }

    private static class IniFile {
        protected Map<String, Map<String, String>> sections = new HashMap<String, Map<String, String>>();
        private String currentSecion;
        private Map<String, String> current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IniFile(InputStream in) {
            if (in == null) {
                SumkException.throwException(245323425, "ini stream cannot be null");
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(in, AppInfo.systemCharset()));
                this.read(reader);
            }
            catch (Exception e) {
                Log.printStack(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        protected void read(BufferedReader reader) throws IOException {
            String line;
            while ((line = reader.readLine()) != null) {
                this.parseLine(line);
            }
        }

        protected void parseLine(String line) {
            if ((line = line.trim()).matches("^\\[.*\\]")) {
                this.currentSecion = line.replaceFirst("\\[(.*)\\]", "$1");
                this.current = new HashMap<String, String>();
                this.sections.put(this.currentSecion, this.current);
            } else if (line.matches(".*=.*") && this.current != null && !line.startsWith("#")) {
                int i = line.indexOf(61);
                String name = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                if (value.isEmpty()) {
                    return;
                }
                this.current.put(name, value);
            }
        }

        public String toString() {
            return this.sections.toString();
        }
    }
}

