/*
 * Decompiled with CFR 0.152.
 */
package org.yx.conf;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.yx.conf.FileHandler;
import org.yx.log.Log;
import org.yx.main.SumkServer;

public class FileMonitor {
    public static final FileMonitor inst = new FileMonitor();
    private List<FileHandler> handlers = new CopyOnWriteArrayList<FileHandler>();
    private Map<String, Long> lastModif = new HashMap<String, Long>();

    private FileMonitor() {
    }

    public void addHandle(FileHandler h) {
        this.handlers.add(h);
        this.handle(h, false);
    }

    public void start() {
        SumkServer.runDeamon(() -> {
            Thread.sleep(1000L);
            for (FileHandler h : this.handlers) {
                this.handle(h, true);
            }
        }, "file-watcher");
    }

    private synchronized void handle(FileHandler h, boolean showLog) {
        URL[] urls = h.listFile();
        if (urls == null) {
            return;
        }
        for (URL url : urls) {
            File f = new File(url.getPath());
            String p = f.getAbsolutePath();
            if (!f.isFile() || !f.exists()) {
                if (this.lastModif.containsKey(p)) continue;
                this.lastModif.put(p, System.currentTimeMillis());
                try (InputStream fin = url.openStream();){
                    h.deal(fin);
                }
                catch (Exception e) {
                    Log.printStack(e);
                }
                continue;
            }
            Long modify = this.lastModif.get(p);
            if (modify != null && f.lastModified() <= modify) continue;
            this.lastModif.put(p, f.lastModified());
            if (showLog) {
                Log.get("sumk.SYS").info("##{} changed at {}", (Object)f, (Object)this.lastModif.get(p));
            }
            try (InputStream fin = url.openStream();){
                h.deal(fin);
            }
            catch (Exception e) {
                Log.printStack(e);
            }
        }
    }

    static {
        inst.start();
    }
}

