/*
 * Decompiled with CFR 0.152.
 */
package org.yx.conf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.yx.log.Log;

public class NamePairs {
    public static final char SPLIT_CHAR = '\u0003';
    public static final String SPLIT = new String(new char[]{'\u0003'});
    private static final Logger LOG = Log.get("sumk.conf");
    private final Map<String, String> map;
    private final String data;

    public NamePairs(String data) {
        String[] vs;
        this.map = new HashMap<String, String>();
        this.data = data;
        if (data == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("data:\n" + data.replace('\u0003', '\n'));
        }
        for (String v : vs = data.split(SPLIT)) {
            String[] namePair;
            if ((v = v.trim()).isEmpty()) continue;
            String[] stringArray = namePair = v.contains("=") ? v.split("=", 2) : v.split(":", 2);
            if (namePair.length < 2) continue;
            this.map.put(namePair[0].trim(), namePair[1].trim());
        }
    }

    private NamePairs(Map<String, String> map, String data) {
        this.map = map;
        this.data = data;
    }

    public String getRawData() {
        return this.data;
    }

    public Map<String, String> values() {
        return Collections.unmodifiableMap(this.map);
    }

    public NamePairs unmodify() {
        return new NamePairs(Collections.unmodifiableMap(this.map), this.data);
    }

    public String getValue(String key) {
        if (key == null) {
            return null;
        }
        return this.map.get(key);
    }

    public String toString() {
        return this.map.toString();
    }
}

