/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db;

import org.yx.exception.SumkException;

public enum DBType {
    WRITE(true, false),
    READ(false, true),
    ANY(true, true);

    private boolean writable;
    private boolean readable;

    public static DBType parse(String type) {
        String type2;
        switch (type2 = type.toLowerCase()) {
            case "w": 
            case "write": {
                return WRITE;
            }
            case "r": 
            case "read": 
            case "readonly": {
                return READ;
            }
            case "wr": 
            case "rw": 
            case "any": {
                return ANY;
            }
        }
        SumkException.throwException(2342312, type + " is not correct db type");
        return null;
    }

    private DBType(boolean writable, boolean readable) {
        this.writable = writable;
        this.readable = readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isReadable() {
        return this.readable;
    }
}

