/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.conn;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.yx.db.DBType;
import org.yx.db.conn.DataSourceFactory;
import org.yx.db.conn.DataSourceWraper;
import org.yx.db.conn.WeightedDataSourceRoute;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.util.Assert;

public class ConnectionFactory {
    private static Map<String, ConnectionFactory> factoryMap = new ConcurrentHashMap<String, ConnectionFactory>();
    private WeightedDataSourceRoute read;
    private WeightedDataSourceRoute write;
    private String db;

    private ConnectionFactory(String dbName) {
        this.db = dbName;
    }

    public Map<String, Map<String, Integer>> status() {
        HashSet<DataSource> set = new HashSet<DataSource>();
        set.addAll(this.read.allDataSource());
        set.addAll(this.write.allDataSource());
        HashMap<String, Map<String, Integer>> statusMap = new HashMap<String, Map<String, Integer>>();
        for (DataSource datasource : set) {
            if (!BasicDataSource.class.isInstance(datasource)) {
                Log.get(this.getClass(), 25345).info("ds.class({}) is not instance form BasicDataSource", (Object)datasource.getClass().getName());
                continue;
            }
            BasicDataSource ds = (BasicDataSource)datasource;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("active", ds.getNumActive());
            map.put("idle", ds.getNumIdle());
            map.put("minIdle", ds.getMinIdle());
            map.put("maxIdle", ds.getMaxIdle());
            map.put("maxTotal", ds.getMaxTotal());
            statusMap.put(ds.toString(), map);
        }
        return statusMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionFactory get(String dbName) {
        try {
            Assert.hasText(dbName, "db name can not be empty");
            dbName = dbName.trim();
            ConnectionFactory factory = factoryMap.get(dbName);
            if (factory != null) {
                return factory;
            }
            Class<ConnectionFactory> clazz = ConnectionFactory.class;
            synchronized (ConnectionFactory.class) {
                factory = factoryMap.get(dbName);
                if (factory != null) {
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return factory;
                }
                factory = new ConnectionFactory(dbName);
                factory.parseDatasource();
                factoryMap.put(dbName, factory);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return factory;
            }
        }
        catch (Exception e) {
            Log.printStack(e);
            SumkException.throwException(100234325, "create factory failed");
            return null;
        }
    }

    void destroy() {
    }

    public static void reload(String dbName) throws Exception {
        Assert.hasText(dbName, "db name can not be empty");
        dbName = dbName.trim();
        ConnectionFactory factory = factoryMap.get(dbName);
        if (factory == null) {
            return;
        }
        factory = new ConnectionFactory(dbName);
        ConnectionFactory old = factoryMap.put(dbName, factory);
        old.destroy();
    }

    private void parseDatasource() throws Exception {
        if (this.write != null || this.read != null) {
            Log.get(this.getClass(), 34534543).info("{} has init datasource", (Object)this.db);
            return;
        }
        Map<DBType, WeightedDataSourceRoute> map = DataSourceFactory.create(this.db);
        this.write = map.get((Object)DBType.WRITE);
        this.read = map.get((Object)DBType.READ);
    }

    public Connection getConnection(DBType type, Connection writeConn) {
        if (!type.isWritable()) {
            try {
                DataSource ds = this.read.datasource();
                if (writeConn != null && DataSourceWraper.class.isInstance(ds)) {
                    DataSourceWraper wrapper = (DataSourceWraper)((Object)ds);
                    wrapper.readConnection(writeConn);
                }
                return ds.getConnection();
            }
            catch (SQLException e) {
                SumkException.throwException(100001, "\u83b7\u53d6" + this.db + "\u8bfb\u8fde\u63a5\u5931\u8d25", e);
            }
        }
        try {
            return this.write.datasource().getConnection();
        }
        catch (SQLException e) {
            SumkException.throwException(100001, "\u83b7\u53d6" + this.db + "\u5199\u8fde\u63a5\u5931\u8d25", e);
            return null;
        }
    }
}

