/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.conn;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.yx.db.DBType;
import org.yx.db.conn.ConnectionFactory;
import org.yx.db.conn.EventLane;
import org.yx.log.Log;
import org.yx.util.Assert;

public final class ConnectionPool
implements AutoCloseable {
    private static ThreadLocal<List<ConnectionPool>> connectionHolder = new ThreadLocal<List<ConnectionPool>>(){

        @Override
        protected List<ConnectionPool> initialValue() {
            return new ArrayList<ConnectionPool>(2);
        }
    };
    private String dbName;
    private DBType dbType;
    private Connection readConn;
    private Connection writeConn;

    public static ConnectionPool create(String dbName, DBType dbType) {
        List<ConnectionPool> list = connectionHolder.get();
        ConnectionPool context = new ConnectionPool();
        context.dbName = dbName;
        context.dbType = dbType;
        list.add(0, context);
        return context;
    }

    public static ConnectionPool createIfAbsent(String dbName, DBType dbType) {
        List<ConnectionPool> list = connectionHolder.get();
        if (list.size() > 0) {
            return null;
        }
        return ConnectionPool.create(dbName, dbType);
    }

    private ConnectionPool() {
    }

    public static ConnectionPool get() {
        List<ConnectionPool> list = connectionHolder.get();
        Assert.isTrue(list.size() > 0, "must open transaction in box or other containers");
        ConnectionPool context = list.get(0);
        return context;
    }

    public static void clossLeakConnection() {
        List<ConnectionPool> list = connectionHolder.get();
        if (list.isEmpty()) {
            connectionHolder.remove();
            return;
        }
        try {
            Log.get("DBConnectionContext").error("###connection leak:" + list.size());
            while (list.size() > 0) {
                list.get(0).close();
            }
            connectionHolder.remove();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventLane.removeALL();
    }

    public Connection connection(DBType type) {
        if (this.dbType == DBType.WRITE) {
            return this.getWriteConnection();
        }
        if (this.dbType == DBType.READ) {
            if (type == DBType.WRITE) {
                return this.getWriteConnection();
            }
            return this.getReadConnection();
        }
        return this.connectionByUser(type);
    }

    private Connection connectionByUser(DBType type) {
        if (type == DBType.ANY) {
            if (this.readConn != null) {
                return this.readConn;
            }
            if (this.writeConn != null) {
                return this.writeConn;
            }
        }
        if (type == DBType.WRITE) {
            return this.getWriteConnection();
        }
        return this.getReadConnection();
    }

    private Connection getReadConnection() {
        Connection conn;
        if (this.readConn != null) {
            return this.readConn;
        }
        ConnectionFactory factory = ConnectionFactory.get(this.dbName);
        this.readConn = conn = factory.getConnection(DBType.READ, this.writeConn);
        Log.get("sumk.conn.open").trace("open read connection:{}", (Object)conn);
        return conn;
    }

    private Connection getWriteConnection() {
        Connection conn;
        if (this.writeConn != null) {
            return this.writeConn;
        }
        ConnectionFactory factory = ConnectionFactory.get(this.dbName);
        this.writeConn = conn = factory.getConnection(DBType.WRITE, null);
        Log.get("sumk.conn.open").trace("open write connection:{}", (Object)conn);
        return conn;
    }

    public Connection getDefaultconnection() {
        return this.connectionByUser(this.dbType);
    }

    public void commit() throws SQLException {
        if (this.writeConn != null) {
            Log.get("sumk.conn").trace("commit {}", (Object)this.dbName);
            this.writeConn.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.writeConn != null) {
            Log.get("sumk.conn").trace("rollback {}", (Object)this.dbName);
            this.writeConn.rollback();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.writeConn != null) {
            try {
                Log.get("sumk.conn.close").trace("close write connection:{}", (Object)this.writeConn);
                this.writeConn.close();
            }
            catch (Exception e) {
                Log.printStack(e);
            }
            this.writeConn = null;
        }
        if (this.readConn != null) {
            try {
                Log.get("sumk.conn.close").trace("close read connection:{}", (Object)this.readConn);
                this.readConn.close();
            }
            catch (Exception e) {
                Log.printStack(e);
            }
            this.readConn = null;
        }
        List<ConnectionPool> list = connectionHolder.get();
        int size = list.size();
        list.remove(this);
        Log.get("sumk.conn").trace("Close connection context [{}], from size {} to {}", new Object[]{this.dbName, size, list.size()});
    }

    public String getDbName() {
        return this.dbName;
    }

    public DBType getDbType() {
        return this.dbType;
    }
}

