/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.conn;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.yx.conf.DBConfig;
import org.yx.conf.DBConfigUtils;
import org.yx.db.DBType;
import org.yx.db.conn.DataSourceWraper;
import org.yx.db.conn.WeightedDS;
import org.yx.db.conn.WeightedDataSourceRoute;

public class DataSourceFactory {
    public static Map<DBType, WeightedDataSourceRoute> create(String db) throws Exception {
        Map<String, Map<String, String>> hmap = DataSourceFactory.parse(db);
        WeightedDataSourceRoute read = new WeightedDataSourceRoute(new WeightedDS[0]);
        WeightedDataSourceRoute write = new WeightedDataSourceRoute(new WeightedDS[0]);
        HashMap<DBType, WeightedDataSourceRoute> poolMap = new HashMap<DBType, WeightedDataSourceRoute>();
        poolMap.put(DBType.READ, read);
        poolMap.put(DBType.WRITE, write);
        for (String key : hmap.keySet()) {
            Map<String, String> p = hmap.get(key);
            DBConfig dc = new DBConfig();
            dc.setProperties(p);
            DataSourceWraper ds = dc.createDS(key);
            if (ds.getType().isWritable()) {
                ds.setDefaultReadOnly(false);
                WeightedDS w = new WeightedDS((DataSource)((Object)ds));
                w.setWeight(dc.getWeight() > 0 ? dc.getWeight() : 1);
                write.addServer(w);
                if (ds.getType() != DBType.ANY) continue;
                WeightedDS r = new WeightedDS((DataSource)((Object)ds));
                r.setWeight(dc.getRead_weight() > 0 ? dc.getRead_weight() : 1);
                read.addServer(r);
                continue;
            }
            if (!ds.getType().isReadable()) continue;
            ds.setDefaultReadOnly(true);
            WeightedDS r = new WeightedDS((DataSource)((Object)ds));
            int w = dc.getRead_weight() > 0 ? dc.getRead_weight() : dc.getWeight();
            r.setWeight(w > 0 ? w : 1);
            read.addServer(r);
        }
        return poolMap;
    }

    static Map<String, Map<String, String>> parse(String db) throws Exception {
        return DBConfigUtils.parseIni(DBConfigUtils.openConfig(db));
    }
}

