/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.conn;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.yx.db.DBType;
import org.yx.db.conn.ConnectionWrapper;
import org.yx.db.conn.SlaveConnectionWrapper;
import org.yx.log.Log;

public class DataSourceWraper
extends BasicDataSource {
    private String name;
    private DBType type;

    public DataSourceWraper(String name, String type) {
        this.name = name;
        this.type = DBType.parse(type);
        if (!this.type.isWritable()) {
            this.setDefaultReadOnly(true);
        }
    }

    public String getName() {
        return this.name;
    }

    public DBType getType() {
        return this.type;
    }

    public Connection getConnection() throws SQLException {
        return new ConnectionWrapper(super.getConnection(), (DataSource)((Object)this));
    }

    public Connection readConnection(Connection write) throws SQLException {
        SlaveConnectionWrapper c;
        if (write != null && ConnectionWrapper.class.isInstance(write) && ((ConnectionWrapper)write).getDataSource() == this && (c = SlaveConnectionWrapper.create((ConnectionWrapper)write)) != null) {
            Log.get("db").trace("use write connection for read");
            return c;
        }
        return new ConnectionWrapper(super.getConnection(), (DataSource)((Object)this));
    }
}

