/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.conn;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.yx.db.conn.WeightedDS;

class WeightedDataSourceRoute {
    private volatile int currentIndex = -1;
    private volatile int currentWeight = 0;
    private int maxWeight;
    private int gcdWeight;
    private List<WeightedDS> serverList;

    public Set<DataSource> allDataSource() {
        HashSet<DataSource> list = new HashSet<DataSource>();
        for (WeightedDS ds : this.serverList) {
            list.add(ds.getDs());
        }
        return list;
    }

    private static int gcd(int a, int b) {
        BigInteger b1 = new BigInteger(String.valueOf(a));
        BigInteger b2 = new BigInteger(String.valueOf(b));
        BigInteger gcd = b1.gcd(b2);
        return gcd.intValue();
    }

    private static int getGCDForServers(List<WeightedDS> serverList) {
        int w = 0;
        int len = serverList.size();
        for (int i = 0; i < len - 1; ++i) {
            w = w == 0 ? WeightedDataSourceRoute.gcd(serverList.get(i).getWeight(), serverList.get(i + 1).getWeight()) : WeightedDataSourceRoute.gcd(w, serverList.get(i + 1).getWeight());
        }
        return w;
    }

    private static int getMaxWeightForServers(List<WeightedDS> serverList) {
        int w = 0;
        for (WeightedDS s : serverList) {
            if (s.getWeight() <= w) continue;
            w = s.getWeight();
        }
        return w;
    }

    public DataSource datasource() {
        WeightedDS sm = this.GetServer();
        if (sm == null) {
            return null;
        }
        return sm.getDs();
    }

    private WeightedDS GetServer() {
        List<WeightedDS> list = this.serverList;
        int serverCount = list.size();
        for (int i = 0; i < serverCount * 2; ++i) {
            int index;
            this.currentIndex = (this.currentIndex + 1) % serverCount;
            if (this.currentIndex == 0) {
                this.currentWeight -= this.gcdWeight;
                if (this.currentWeight <= 0) {
                    this.currentWeight = this.maxWeight;
                    if (this.currentWeight == 0) {
                        return null;
                    }
                }
            }
            if (list.get(index = this.currentIndex % serverCount).getWeight() < this.currentWeight) continue;
            return list.get(index);
        }
        return null;
    }

    public void addServer(WeightedDS s) {
        ArrayList<WeightedDS> list = new ArrayList<WeightedDS>(this.serverList);
        list.add(s);
        this.init(list);
    }

    public void removeServer(DataSource ds) {
        ArrayList<WeightedDS> list = new ArrayList<WeightedDS>(this.serverList);
        for (WeightedDS s : list) {
            if (!s.getDs().equals(ds)) continue;
            list.remove(s);
            break;
        }
        this.init(list);
    }

    public WeightedDataSourceRoute(WeightedDS ... servers) {
        ArrayList<WeightedDS> list = new ArrayList<WeightedDS>(8);
        Arrays.stream(servers).forEach(s -> list.add((WeightedDS)s));
        this.init(list);
    }

    public WeightedDataSourceRoute(Collection<WeightedDS> servers) {
        this.init(servers);
    }

    private void init(Collection<WeightedDS> list) {
        this.serverList = new ArrayList<WeightedDS>(list.size());
        this.serverList.addAll(list);
        this.maxWeight = WeightedDataSourceRoute.getMaxWeightForServers(this.serverList);
        this.gcdWeight = WeightedDataSourceRoute.getGCDForServers(this.serverList);
    }
}

