/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.exec;

import java.io.IOException;
import java.sql.SQLException;
import org.yx.db.DBAction;
import org.yx.db.DBType;
import org.yx.db.conn.ConnectionPool;
import org.yx.db.exec.DBExecutor;
import org.yx.db.exec.ExeContext;
import org.yx.db.exec.ResultContainer;

public class DBSessionProxy
implements DBAction {
    private DBType dbType;
    private ResultContainer container;
    private ConnectionPool dbCtx = null;

    public static DBSessionProxy create(ResultContainer container, DBType dbType) {
        return new DBSessionProxy(dbType, container);
    }

    public DBSessionProxy(DBType dbType, ResultContainer container) {
        this.dbType = dbType;
        this.container = container;
    }

    public void exec(DBExecutor executor) throws Exception {
        try {
            ExeContext context = new ExeContext();
            context.param = this.container.getParam();
            context.action = this;
            this.dbCtx = ConnectionPool.create(this.container.getDb(), this.dbType);
            executor.exec(context);
            this.dbCtx.commit();
            this.container.result = context.getResult();
        }
        catch (Exception e) {
            if (this.dbCtx != null) {
                this.dbCtx.rollback();
            }
            throw e;
        }
        finally {
            if (this.dbCtx != null) {
                this.dbCtx.close();
            }
        }
    }

    @Override
    public void commit() throws IOException, SQLException {
        this.dbCtx.commit();
    }

    @Override
    public void rollback() throws IOException, SQLException {
        this.dbCtx.rollback();
    }
}

