/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yx.conf.AppInfo;
import org.yx.db.sql.PojoMeta;
import org.yx.db.sql.PojoMetaHolder;
import org.yx.db.sql.SqlBuilder;
import org.yx.db.visit.SumkDbVisitor;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.util.Assert;
import org.yx.util.CollectionUtils;

public abstract class AbstractSqlBuilder<T>
implements SqlBuilder {
    static boolean FAIL_IF_PROPERTY_NOT_MAPPED;
    protected boolean withnull;
    protected SumkDbVisitor<T> visitor;
    protected Class<?> tableClass;
    protected PojoMeta pojoMeta;
    protected List<Map<String, Object>> in;

    protected void checkIn() {
        Assert.isTrue(CollectionUtils.isNotEmpty(this.in), "no conditions");
    }

    protected void _addIn(Object src) {
        if (src == null) {
            return;
        }
        if (this.in == null) {
            this.in = new ArrayList<Map<String, Object>>();
        }
        if (Map.class.isInstance(src)) {
            Map map = (Map)src;
            if (!map.isEmpty()) {
                this.in.add(map);
            }
            return;
        }
        this.pojoMeta = PojoMetaHolder.getPojoMeta(src.getClass());
        if (this.pojoMeta == null) {
            SumkException.throwException(3654, src.getClass() + " does not config as a table");
        }
        try {
            this.in.add(this.pojoMeta.populate(src, this.withnull));
        }
        catch (Exception e) {
            SumkException.throwException(534254, e.getMessage(), e);
        }
    }

    public PojoMeta getPojoMeta() {
        if (this.tableClass != null) {
            return PojoMetaHolder.getPojoMeta(this.tableClass);
        }
        return this.pojoMeta;
    }

    public AbstractSqlBuilder(SumkDbVisitor<T> visitor) {
        this.visitor = visitor;
    }

    protected T accept(SumkDbVisitor<T> visitor) {
        try {
            return visitor.visit(this);
        }
        catch (Exception e) {
            throw new SumkException(435, e.getMessage(), e);
        }
    }

    static {
        AppInfo.addObserver((a, b) -> {
            try {
                FAIL_IF_PROPERTY_NOT_MAPPED = AppInfo.getBoolean("sumk.sql.failIfPropertyNotMapped", true);
            }
            catch (Exception e) {
                Log.get("sumk.appInfo").info(e.getMessage(), (Throwable)e);
            }
        });
    }
}

