/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.lang.reflect.Field;
import java.util.Map;
import org.yx.db.annotation.ColumnType;

public class ColumnMeta
implements Comparable<ColumnMeta> {
    private Field field;
    private ColumnType meta;
    private byte columnOrder = (byte)64;
    private String dbColumn;

    byte getColumnOrder() {
        return this.columnOrder;
    }

    void setColumnOrder(byte columnOrder) {
        this.columnOrder = columnOrder;
    }

    public String getDbColumn() {
        return this.dbColumn;
    }

    void setDbColumn(String dbColumn) {
        this.dbColumn = dbColumn;
    }

    public ColumnMeta(Field field, ColumnType meta) {
        this.field = field;
        this.meta = meta;
        this.dbColumn = this.field.getName().toLowerCase();
    }

    public boolean isDBID() {
        return ColumnType.ID_DB.accept(this.meta);
    }

    public boolean isRedisID() {
        return ColumnType.ID_CACHE.accept(this.meta);
    }

    public boolean accept(ColumnType type) {
        return this.meta.accept(type);
    }

    public Object value(Object owner) throws IllegalArgumentException, IllegalAccessException {
        if (Map.class.isInstance(owner)) {
            Map map = (Map)owner;
            return map.get(this.field.getName());
        }
        return this.field.get(owner);
    }

    void setValue(Object owner, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (Map.class.isInstance(owner)) {
            Map map = (Map)owner;
            map.put(this.field.getName(), value);
            return;
        }
        this.field.set(owner, value);
    }

    public Field getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    @Override
    public int compareTo(ColumnMeta o) {
        if (this.columnOrder == o.getColumnOrder()) {
            return this.getDbColumn().compareTo(o.getDbColumn());
        }
        return this.columnOrder > o.getColumnOrder() ? 1 : -1;
    }

    public String toString() {
        return "ColumnMeta [field=" + this.field.getName() + ", meta=" + (Object)((Object)this.meta) + ", columnOrder=" + this.columnOrder + ", dbColumn=" + this.dbColumn + "]";
    }
}

