/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yx.db.event.InsertEvent;
import org.yx.db.sql.AbstractSqlBuilder;
import org.yx.db.sql.ColumnMeta;
import org.yx.db.sql.ItemJoiner;
import org.yx.db.sql.MapedSql;
import org.yx.db.sql.PojoMeta;
import org.yx.db.visit.SumkDbVisitor;
import org.yx.util.SeqUtil;

public class Insert
extends AbstractSqlBuilder<Integer> {
    private List<Object> src = new ArrayList<Object>();

    public Insert(SumkDbVisitor<Integer> visitor) {
        super(visitor);
    }

    public int execute() {
        return (Integer)this.accept(this.visitor);
    }

    public Insert insert(Object pojo) {
        this.src.add(pojo);
        this._addIn(pojo);
        return this;
    }

    public Insert tableClass(Class<?> tableClass) {
        this.tableClass = tableClass;
        return this;
    }

    @Override
    public MapedSql toMapedSql() throws InstantiationException, IllegalAccessException {
        this.checkIn();
        this.pojoMeta = this.getPojoMeta();
        return this.in.size() == 1 ? this.singleInsert() : this.batchInsert();
    }

    private MapedSql singleInsert() throws InstantiationException, IllegalAccessException {
        Map pojoMap = (Map)this.in.get(0);
        MapedSql ms = new MapedSql();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this.pojoMeta.getTableName());
        sb.append(" (");
        boolean notFirst = false;
        StringBuilder values = new StringBuilder();
        ColumnMeta[] fms = this.pojoMeta.fieldMetas;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ColumnMeta fm : fms) {
            String name = fm.getDbColumn();
            Object value = fm.value(pojoMap);
            if (value == null) {
                if (!fm.isDBID() || !this.canUseAutoID(this.pojoMeta)) continue;
                value = SeqUtil.next(this.pojoMeta.getTableName());
                fm.setValue(pojoMap, value);
                fm.setValue(this.src.get(0), value);
            }
            if (notFirst) {
                sb.append(',');
                values.append(',');
            }
            notFirst = true;
            sb.append(name);
            ms.addParam(value);
            map.put(fm.getFieldName(), value);
            values.append('?');
        }
        if (this.pojoMeta.isSoftDelete()) {
            String columnName = this.pojoMeta.softDelete.columnName;
            sb.append(',').append(columnName);
            values.append(",?");
            ms.addParam(this.pojoMeta.softDelete.validValue);
        }
        sb.append(')');
        sb.append(" VALUES ");
        sb.append('(');
        sb.append((CharSequence)values);
        sb.append(')');
        ms.sql = sb.toString();
        InsertEvent event = new InsertEvent(this.pojoMeta.getTableName(), Collections.singletonList(map));
        ms.event = event;
        return ms;
    }

    private MapedSql batchInsert() throws InstantiationException, IllegalAccessException {
        MapedSql ms = new MapedSql();
        ItemJoiner columns = ItemJoiner.create(",");
        ItemJoiner placeholder = ItemJoiner.create(",");
        ColumnMeta[] fms = this.pojoMeta.fieldMetas;
        int recodeSize = this.in.size();
        for (ColumnMeta fm : fms) {
            String name = fm.getDbColumn();
            columns.item().append(name);
            placeholder.item().append('?');
        }
        if (this.pojoMeta.isSoftDelete()) {
            String columnName = this.pojoMeta.softDelete.columnName;
            columns.item().append(columnName);
            placeholder.item().append('?');
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(this.pojoMeta.getTableName()).append(columns.toCharSequence(true)).append(" VALUES ");
        CharSequence place = placeholder.toCharSequence(true);
        for (int i = 0; i < recodeSize; ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append(place);
        }
        ms.sql = sql.toString();
        ArrayList<Map<String, Object>> cacheList = new ArrayList<Map<String, Object>>(recodeSize);
        for (int i = 0; i < recodeSize; ++i) {
            Map pojoMap = (Map)this.in.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            cacheList.add(map);
            for (ColumnMeta fm : fms) {
                Object value = fm.value(pojoMap);
                if (value == null && fm.isDBID() && this.canUseAutoID(this.pojoMeta)) {
                    value = SeqUtil.next(this.pojoMeta.getTableName());
                    fm.setValue(pojoMap, value);
                    fm.setValue(this.src.get(i), value);
                }
                ms.addParam(value);
                map.put(fm.getFieldName(), value);
            }
            if (!this.pojoMeta.isSoftDelete()) continue;
            ms.addParam(this.pojoMeta.softDelete.validValue);
        }
        InsertEvent event = new InsertEvent(this.pojoMeta.getTableName(), cacheList);
        ms.event = event;
        return ms;
    }

    private boolean canUseAutoID(PojoMeta pm) {
        ColumnMeta[] ids = pm.getPrimaryIDs();
        if (ids.length != 1) {
            return false;
        }
        Class<?> f = ids[0].getField().getType();
        return Long.class == f;
    }
}

