/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

public class ItemJoiner {
    private StringBuilder sb = new StringBuilder();
    private final CharSequence delimiter;
    private final CharSequence prefix;
    private final CharSequence suffix;
    private boolean hasDelimiter;

    static ItemJoiner create() {
        return ItemJoiner.create(" AND ");
    }

    static ItemJoiner create(CharSequence delimiter) {
        return new ItemJoiner(delimiter, " ( ", " ) ");
    }

    public ItemJoiner(CharSequence delimiter, CharSequence pre, CharSequence suf) {
        this.delimiter = delimiter;
        this.prefix = pre;
        this.suffix = suf;
    }

    public ItemJoiner(CharSequence delimiter) {
        this(delimiter, null, null);
    }

    public ItemJoiner item() {
        if (this.sb.length() > 0) {
            this.sb.append(this.delimiter);
            this.hasDelimiter = true;
        }
        return this;
    }

    public ItemJoiner append(CharSequence v) {
        this.sb.append(v);
        return this;
    }

    public ItemJoiner append(char v) {
        this.sb.append(v);
        return this;
    }

    public CharSequence toCharSequence() {
        return this.toCharSequence(false);
    }

    public CharSequence toCharSequence(boolean forceBorder) {
        if (this.sb == null || this.sb.length() == 0) {
            return null;
        }
        if (!forceBorder && !this.hasDelimiter) {
            return this.sb;
        }
        StringBuilder ret = new StringBuilder();
        if (this.prefix != null) {
            ret.append(this.prefix);
        }
        ret.append((CharSequence)this.sb);
        if (this.suffix != null) {
            ret.append(this.suffix);
        }
        return ret;
    }

    public String toString() {
        return String.valueOf(this.toCharSequence());
    }

    public ItemJoiner addNotEmptyItem(CharSequence item) {
        if (item == null || item.length() == 0) {
            return this;
        }
        this.item().append(item);
        return this;
    }
}

