/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.yx.bean.IOC;
import org.yx.conf.AppInfo;
import org.yx.db.annotation.CacheType;
import org.yx.db.annotation.SoftDelete;
import org.yx.db.annotation.Table;
import org.yx.db.sql.ColumnMeta;
import org.yx.db.sql.SoftDeleteMeta;
import org.yx.db.sql.SoftDeleteParser;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.redis.Counter;
import org.yx.redis.RedisPool;
import org.yx.util.StringUtils;

public class PojoMeta {
    private static final char KEY_SPLIT = ',';
    private final Table table;
    final ColumnMeta[] fieldMetas;
    public final Class<?> pojoClz;
    private ColumnMeta[] redisIDs;
    private ColumnMeta[] primaryIDs;
    private Counter counter;
    private int ttlSec;
    private String pre;
    private long lastHitTime;
    private String tableName;
    final SoftDeleteMeta softDelete;
    private Map<String, ColumnMeta> columnDBNameMap = new HashMap<String, ColumnMeta>();
    private Map<String, ColumnMeta> filedNameMap = new HashMap<String, ColumnMeta>();
    private Type pojoArrayClz;

    public Type pojoArrayClz() {
        return this.pojoArrayClz;
    }

    public ColumnMeta getByColumnDBName(String columnDBName) {
        if (columnDBName == null || columnDBName.isEmpty()) {
            return null;
        }
        return this.columnDBNameMap.get(columnDBName.toLowerCase());
    }

    public ColumnMeta getByFieldName(String filedName) {
        if (filedName == null || filedName.isEmpty()) {
            return null;
        }
        return this.filedNameMap.get(filedName.toLowerCase());
    }

    public boolean isNoCache() {
        return this.table.cacheType() == CacheType.NOCACHE || RedisPool.defaultRedis() == null || this.redisIDs.length == 0;
    }

    public CacheType cacheType() {
        return this.table.cacheType();
    }

    public boolean isPrimeKeySameWithReids() {
        return this.primaryIDs == this.redisIDs;
    }

    public ColumnMeta[] getPrimaryIDs() {
        return this.primaryIDs;
    }

    public boolean isSoftDelete() {
        return this.softDelete != null;
    }

    public long getLastHitTime() {
        return this.lastHitTime;
    }

    public void setLastHitTime(long lastHitTime) {
        this.lastHitTime = lastHitTime;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public int getTtlSec() {
        return this.ttlSec;
    }

    PojoMeta(Table table, ColumnMeta[] fieldMetas, Class<?> pojoClz) {
        this.table = table;
        this.fieldMetas = fieldMetas;
        this.pojoClz = pojoClz;
        ArrayList<ColumnMeta> rids = new ArrayList<ColumnMeta>();
        ArrayList<ColumnMeta> pids = new ArrayList<ColumnMeta>();
        for (ColumnMeta m : this.fieldMetas) {
            this.columnDBNameMap.put(m.getDbColumn().toLowerCase(), m);
            this.filedNameMap.put(m.getFieldName().toLowerCase(), m);
            if (m.isRedisID()) {
                rids.add(m);
            }
            if (m.isDBID()) {
                pids.add(m);
            }
            this.redisIDs = rids.toArray(new ColumnMeta[rids.size()]);
            this.primaryIDs = pids.equals(rids) ? this.redisIDs : pids.toArray(new ColumnMeta[pids.size()]);
        }
        this.softDelete = IOC.get(SoftDeleteParser.class).parse(this.pojoClz.getAnnotation(SoftDelete.class));
        this.parseTable();
        String arrayName = "[L" + this.pojoClz.getName() + ";";
        try {
            this.pojoArrayClz = Class.forName(arrayName, false, this.getClass().getClassLoader());
        }
        catch (Exception e) {
            SumkException.throwException(0x344441, arrayName + " can not be loaded", e);
        }
    }

    private void parseTable() {
        int ttl = this.table.duration();
        this.ttlSec = ttl > 0 ? ttl : (ttl == 0 ? AppInfo.getInt("sumk.cache.ttl", 21600) : -1);
        int beats = this.table.maxBeats();
        this.counter = beats == 0 ? new Counter(AppInfo.getInt("sumk.cache.count", 500)) : new Counter(Integer.MAX_VALUE);
        String _pre = this.table.preInCache();
        this.pre = StringUtils.isEmpty(_pre) ? this.pojoClz.getSimpleName() : _pre;
        this.tableName = StringUtils.isEmpty(this.table.value()) ? this.pojoClz.getSimpleName().toLowerCase() : this.table.value();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPre() {
        return this.pre;
    }

    public boolean isOnlyRedisID(Object condition) throws IllegalArgumentException, IllegalAccessException {
        if (this.pojoClz.isInstance(condition)) {
            for (ColumnMeta m : this.fieldMetas) {
                Object v = m.value(condition);
                if (m.isRedisID() != (v == null)) continue;
                return false;
            }
            return true;
        }
        if (Map.class.isInstance(condition)) {
            Map map = (Map)condition;
            if (map.size() != this.redisIDs.length) {
                return false;
            }
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                String key;
                ColumnMeta cm;
                if (entry.getValue() == null || (cm = this.getByFieldName(key = (String)entry.getKey())) != null && cm.isRedisID()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ColumnMeta[] getRedisIDs() {
        return this.redisIDs;
    }

    public Object buildFromDBColumn(Map<String, Object> map) throws InstantiationException, IllegalAccessException {
        if (map == null) {
            return null;
        }
        Object ret = this.pojoClz.newInstance();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> en : set) {
            String key = en.getKey();
            ColumnMeta m = this.getByColumnDBName(key);
            m.setValue(ret, en.getValue());
        }
        return ret;
    }

    public Map<String, Object> populate(Object source, boolean withnull) throws InstantiationException, IllegalAccessException {
        if (Map.class.isInstance(source)) {
            return (Map)source;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.pojoClz.isInstance(source)) {
            SumkException.throwException(548092345, source.getClass().getName() + " is not instance of " + this.pojoClz.getName());
        }
        for (ColumnMeta m : this.fieldMetas) {
            Object v = m.value(source);
            if (!withnull && v == null) continue;
            String name = m.getFieldName();
            map.put(name, v);
        }
        return map;
    }

    public Object buildPojo(Map<String, Object> map) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Object obj = this.pojoClz.newInstance();
        for (ColumnMeta m : this.fieldMetas) {
            Object v = map.get(m.getFieldName());
            if (v == null) continue;
            m.setValue(obj, v);
        }
        return obj;
    }

    public Map<String, Object> populateByDbColumn(Object source, boolean withnull) throws InstantiationException, IllegalAccessException {
        if (Map.class.isInstance(source)) {
            return (Map)source;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.pojoClz.isInstance(source)) {
            Log.get("event").debug("{} is not instance of {}", (Object)source.getClass().getName(), (Object)this.pojoClz.getName());
            return map;
        }
        for (ColumnMeta m : this.fieldMetas) {
            Object v = m.value(source);
            if (!withnull && v == null) continue;
            String name = m.getDbColumn();
            map.put(name, v);
        }
        return map;
    }

    public String getRedisID(Object source, boolean exceptionIfHasNull) throws Exception {
        if (Map.class.isInstance(source)) {
            return this.getRedisIDByMap((Map)source, exceptionIfHasNull);
        }
        StringBuilder key = new StringBuilder();
        for (ColumnMeta m : this.redisIDs) {
            Object v = m.value(source);
            if (v == null) {
                if (exceptionIfHasNull) {
                    SumkException.throwException(1232142356, "value of " + m.getFieldName() + " cannot be null");
                }
                return null;
            }
            if (key.length() > 0) {
                key.append(',');
            }
            key.append(v);
        }
        return key.toString();
    }

    public String getRedisIDWithNULL(Map<String, Object> map) throws Exception {
        StringBuilder key = new StringBuilder();
        for (ColumnMeta m : this.redisIDs) {
            Object v = map.get(m.getFieldName());
            if (key.length() > 0) {
                key.append(',');
            }
            key.append(v);
        }
        return key.toString();
    }

    private String getRedisIDByMap(Map<String, Object> map, boolean exceptionIfHasNull) {
        StringBuilder key = new StringBuilder();
        for (ColumnMeta m : this.redisIDs) {
            Object v = map.get(m.getFieldName());
            if (v == null) {
                if (exceptionIfHasNull) {
                    SumkException.throwException(1232142356, "redis key [" + m.getFieldName() + "] cannot be null");
                }
                return null;
            }
            if (key.length() > 0) {
                key.append(',');
            }
            key.append(v);
        }
        return key.toString();
    }
}

