/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.yx.db.annotation.Column;
import org.yx.db.annotation.ColumnType;
import org.yx.db.annotation.Table;
import org.yx.db.sql.ColumnMeta;
import org.yx.db.sql.PojoMeta;
import org.yx.exception.SumkException;
import org.yx.log.Log;
import org.yx.util.StringUtils;

public class PojoMetaHolder {
    private static Map<Class<?>, PojoMeta> pojoMetas = new ConcurrentHashMap();
    private static Map<String, PojoMeta> tableMetas = new ConcurrentHashMap<String, PojoMeta>();

    public static PojoMeta getTableMeta(String table) {
        return tableMetas.get(table);
    }

    public static PojoMeta getPojoMeta(Class<?> clz) {
        if (clz == null || clz.isInterface() || clz == Object.class) {
            return null;
        }
        for (Class<?> tmp = clz; tmp != Object.class; tmp = tmp.getSuperclass()) {
            PojoMeta m = pojoMetas.get(tmp);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public static void resolve(Class<?> pojoClz) {
        Table table = pojoClz.getAnnotation(Table.class);
        if (table == null) {
            return;
        }
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Class<?> clz = pojoClz; clz != Object.class; clz = clz.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = clz.getDeclaredFields()) {
                map.putIfAbsent(f.getName(), f);
            }
        }
        LinkedList<ColumnMeta> list = new LinkedList<ColumnMeta>();
        Collection set = map.values();
        for (Field f : set) {
            Column c = f.getAnnotation(Column.class);
            f.setAccessible(true);
            if (c == null) {
                list.add(new ColumnMeta(f, ColumnType.NORMAL));
                continue;
            }
            ColumnMeta cm = new ColumnMeta(f, c.columnType());
            cm.setColumnOrder(c.columnOrder());
            cm.setDbColumn(StringUtils.isEmpty(c.value()) ? f.getName().toLowerCase() : c.value());
            list.add(cm);
        }
        if (list.isEmpty()) {
            Log.get("pojo").debug("{}'s column is empty", (Object)pojoClz.getName());
            return;
        }
        Collections.sort(list);
        PojoMeta tm = new PojoMeta(table, list.toArray(new ColumnMeta[0]), pojoClz);
        if (tm.getPrimaryIDs().length == 0) {
            SumkException.throwException(56456456, pojoClz.getName() + " has no primary key");
        }
        pojoMetas.put(pojoClz, tm);
        tableMetas.put(tm.getTableName(), tm);
    }
}

