/*
 * Decompiled with CFR 0.152.
 */
package org.yx.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yx.db.event.DBEventPublisher;
import org.yx.db.event.QueryEvent;
import org.yx.db.sql.ColumnMeta;
import org.yx.db.sql.SelectBuilder;
import org.yx.db.visit.Exchange;
import org.yx.db.visit.PojoResultHandler;
import org.yx.db.visit.ResultHandler;
import org.yx.db.visit.SumkDbVisitor;
import org.yx.exception.SumkException;
import org.yx.util.Assert;
import org.yx.util.CollectionUtils;
import org.yx.util.SBuilder;

public class Select
extends SelectBuilder {
    private static final int MAX_CACHE_LIMIT = 5000;
    private ResultHandler resultHandler;

    public Select(SumkDbVisitor<List<Map<String, Object>>> visitor) {
        super(visitor);
    }

    public Select allowEmptyWhere(boolean empty) {
        this.allowEmptyWhere = empty;
        return this;
    }

    public Select resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    private Select setCompare(int index, Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            return this;
        }
        if (this._compare == null) {
            this._compare = new HashMap[4];
        }
        this._compare[index] = map;
        return this;
    }

    private Select setCompare(int index, String key, Object value) {
        if (key == null || key.isEmpty() || value == null) {
            return this;
        }
        if (this._compare == null) {
            this._compare = new HashMap[4];
        }
        if (this._compare[index] == null) {
            this._compare[index] = new HashMap();
        }
        this._compare[index].put(key, value);
        return this;
    }

    public Select bigThan(String key, Object value) {
        return this.setCompare(0, key, value);
    }

    public Select bigOrEqual(String key, Object value) {
        return this.setCompare(1, key, value);
    }

    public Select lessThan(String key, Object value) {
        return this.setCompare(2, key, value);
    }

    public Select lessOrEqual(String key, Object value) {
        return this.setCompare(3, key, value);
    }

    public Select bigThan(Map<String, Object> map) {
        return this.setCompare(0, map);
    }

    public Select bigOrEqual(Map<String, Object> map) {
        return this.setCompare(1, map);
    }

    public Select lessThan(Map<String, Object> map) {
        return this.setCompare(2, map);
    }

    public Select lessOrEqual(Map<String, Object> map) {
        return this.setCompare(3, map);
    }

    public Select orderByAsc(String field) {
        return this.addOrderBy(field, false);
    }

    private Select addOrderBy(String name, boolean desc) {
        if (this.orderby == null) {
            this.orderby = new ArrayList();
        }
        SelectBuilder.Order order = new SelectBuilder.Order();
        order.name = name;
        order.desc = desc;
        this.orderby.add(order);
        return this;
    }

    public Select orderByDesc(String field) {
        return this.addOrderBy(field, true);
    }

    public Select offset(int offset) {
        this.offset = offset;
        return this;
    }

    public Select limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Select selectColumns(String ... columns) {
        if (columns == null || columns.length == 0) {
            this.selectColumns = null;
            return this;
        }
        this.selectColumns = Arrays.asList(columns);
        return this;
    }

    public Select fromCache(boolean fromCache) {
        this.fromCache = fromCache;
        return this;
    }

    public Select toCache(boolean toCache) {
        this.toCache = toCache;
        return this;
    }

    public Select failIfPropertyNotMapped(boolean fail) {
        this.failIfPropertyNotMapped = fail;
        return this;
    }

    public Select parseNULL(boolean v) {
        this.withnull = v;
        return this;
    }

    public Select addEqual(Object src) {
        this._addIn(src);
        return this;
    }

    public Select addEqual(String field, Object value) {
        this._addIn(SBuilder.map(field, value).toMap());
        return this;
    }

    public Select byPrimaryId(Object ... ids) {
        return this.byId(true, ids);
    }

    public Select byRedisId(Object ... ids) {
        return this.byId(false, ids);
    }

    private Select byId(boolean dbPrimary, Object ... ids) {
        if (ids == null || ids.length == 0) {
            return this;
        }
        this.pojoMeta = this.getPojoMeta();
        Assert.notNull(this.pojoMeta, "make suer tableClass() has been called");
        ColumnMeta[] cms = dbPrimary ? this.pojoMeta.getPrimaryIDs() : this.pojoMeta.getRedisIDs();
        Assert.isTrue(cms != null && cms.length == 1, this.pojoMeta.getTableName() + " is not an one " + (dbPrimary ? "primary" : "redis") + " key table");
        String key = cms[0].getFieldName();
        Arrays.asList(ids).forEach(id -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(key, id);
            this.addEqual(map);
        });
        return this;
    }

    public Select addEquals(List<Map<String, Object>> ins) {
        this.in.addAll(ins);
        return this;
    }

    public Select tableClass(Class<?> tableClass) {
        this.tableClass = tableClass;
        return this;
    }

    protected ResultHandler resultHandler() {
        return this.resultHandler == null ? PojoResultHandler.handler : this.resultHandler;
    }

    public <T> List<T> queryList() {
        try {
            List tmp;
            ResultHandler handler = this.resultHandler();
            this.pojoMeta = this.getPojoMeta();
            ArrayList list = new ArrayList();
            List origin = this.in;
            Exchange exchange = new Exchange(origin);
            if (this.fromCache && this.selectColumns == null && this._compare == null && this.orderby == null && this.offset == 0) {
                exchange.findFromCache(this.pojoMeta);
                if (exchange.getData() != null && exchange.getData().size() > 0 && (tmp = handler.parseFromJson(this.pojoMeta, exchange.getData())) != null && tmp.size() > 0) {
                    list.addAll(tmp);
                }
            }
            if (this.in != exchange.getLeftIn() && CollectionUtils.isNotEmpty(this.in) && CollectionUtils.isEmpty(exchange.getLeftIn())) {
                return list;
            }
            this.in = exchange.getLeftIn();
            tmp = handler.parse(this.pojoMeta, (List)this.accept(this.visitor));
            this.in = origin;
            if (tmp == null || tmp.isEmpty()) {
                return list;
            }
            list.addAll(tmp);
            if (this.toCache && this.selectColumns == null && this._compare == null && this.offset == 0 && (this.limit <= 0 || this.limit >= 5000) && exchange.getCanToRedis() != null && exchange.getCanToRedis().size() > 0) {
                QueryEvent event = new QueryEvent(this.getPojoMeta().getTableName());
                event.setIn(exchange.getCanToRedis());
                event.setResult(tmp);
                DBEventPublisher.publish(event);
            }
            if (this.limit > 0 && list.size() > this.limit) {
                return list.subList(0, this.limit);
            }
            return list;
        }
        catch (Exception e) {
            throw SumkException.create(e);
        }
    }

    public <T> T queryOne() {
        List<T> list = this.queryList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

